/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jar;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.reflect.Reflects;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manifests {
    private static final Logger logger = LoggerFactory.getLogger(Manifests.class);

    public static Manifest loadManifest() {
        URL url = Reflects.getCodeLocation(Manifests.class);
        if (url.getPath().endsWith("target/classes/")) {
            return null;
        }
        String jarPath = url.getPath();
        if (jarPath.startsWith("file:")) {
            jarPath = jarPath.replaceFirst("file:", "");
        }
        return Manifests.loadManifest(jarPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest loadManifest(@Nullable String jarPath) {
        Manifest manifest;
        if (jarPath == null) {
            return null;
        }
        String path0 = jarPath;
        String[] pathSegments = jarPath.split("!\\/");
        if (!Emptys.isEmpty(pathSegments)) {
            for (String segment : pathSegments) {
                if (Emptys.isEmpty(segment)) continue;
                jarPath = segment;
                break;
            }
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            manifest = jarFile.getManifest();
        }
        catch (Throwable ex) {
            Manifest manifest2;
            try {
                logger.warn("Can't find the jar : {}", (Object)path0);
                manifest2 = null;
            }
            catch (Throwable throwable) {
                IOs.close(jarFile);
                throw throwable;
            }
            IOs.close(jarFile);
            return manifest2;
        }
        IOs.close(jarFile);
        return manifest;
    }

    public static Manifest getManifest(Class<?> klass) {
        JarFile jarFile = ClassLoaders.getJarFile(klass);
        try {
            if (jarFile != null) {
                return jarFile.getManifest();
            }
        }
        catch (Throwable ex) {
            logger.warn("Can't find the jar for class: {}", (Object)Reflects.getFQNClassName(klass));
            IOs.close(jarFile);
        }
        return null;
    }

    public static String getClassVersion(Class<?> klass) {
        Package p = klass.getPackage();
        if (p != null) {
            return p.getImplementationVersion();
        }
        Manifest manifest = Manifests.getManifest(klass);
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        String version = attributes.getValue("Implementation-Version");
        if (Emptys.isNotEmpty(version)) {
            return version;
        }
        return null;
    }
}

