/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.os.Platform;
import java.util.concurrent.TimeUnit;

public class ThreadPoolProperties {
    private int coreSize = Platform.cpuCore();
    private int maxSize = 2 * this.coreSize;
    private long keepAliveTime = 3L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private int queueSize = 100;

    public void setCoreSize(int coreSize) {
        Preconditions.checkArgument(coreSize > 0);
        this.coreSize = coreSize;
    }

    public void setMaxSize(int maxSize) {
        Preconditions.checkArgument(this.coreSize > 0);
        this.maxSize = maxSize;
    }

    public int getCoreSize() {
        return this.coreSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public ThreadPoolProperties() {
    }

    public ThreadPoolProperties(int coreThreads, int maxThreads, long keepAliveTime, TimeUnit unit, int queueSize) {
        this.coreSize = coreThreads;
        this.maxSize = maxThreads;
        this.keepAliveTime = keepAliveTime;
        this.unit = unit;
        this.queueSize = queueSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }
}

