/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.tree;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.tree.CommonTree;
import com.jn.langx.util.collection.tree.Tree;
import com.jn.langx.util.collection.tree.TreeNode;
import com.jn.langx.util.function.Consumer2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SimpleTree
implements Tree<TreeNode> {
    private static final long serialVersionUID = -9051148743662948065L;
    private List<TreeNode> nodes = new ArrayList<TreeNode>();
    private transient Map<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();

    public SimpleTree() {
        this(null);
    }

    public SimpleTree(Collection<TreeNode> nodes) {
        if (nodes != null) {
            this.nodes.addAll(nodes);
        }
    }

    @Override
    public void addNode(TreeNode node) {
        this.nodes.add(node);
        this.nodeMap.put(node.getId(), node);
    }

    @Override
    public void addNode(String pid, TreeNode node) {
        node.setPid(pid);
        this.addNode(node);
    }

    @Override
    public void addNodes(List<TreeNode> nodes) {
        if (nodes != null) {
            for (TreeNode node : nodes) {
                this.addNode(node);
            }
        }
    }

    @Override
    public void addNodes(String pid, List<TreeNode> nodes) {
        for (TreeNode node : nodes) {
            this.addNode(pid, node);
        }
    }

    @Override
    public void removeNode(TreeNode node, boolean recursion) {
        Collection<TreeNode> children;
        this.nodes.remove(node);
        this.nodeMap.remove(node.getId());
        if (recursion && (children = this.getChildren(node.getId())) != null && !children.isEmpty()) {
            for (TreeNode n : children) {
                this.removeNode(n, recursion);
            }
        }
    }

    @Override
    public void removeNode(TreeNode node) {
        this.removeNode(node, false);
    }

    public List<TreeNode> removeChildNodes(String pid) {
        if (pid == null) {
            return Collections.emptyList();
        }
        LinkedList<TreeNode> removed = new LinkedList<TreeNode>();
        this.removeChildNodes(pid, removed);
        return removed;
    }

    public void removeChildNodes(String pid, List<TreeNode> removed) {
        TreeNode node = this.nodeMap.get(pid);
        Collection<TreeNode> children = this.getChildren(node.getId());
        if (children != null && !children.isEmpty()) {
            for (TreeNode n : children) {
                this.removeChildNodes(n.getId(), removed);
                this.removeNode(n, false);
            }
            removed.addAll(children);
        }
    }

    @Override
    public TreeNode getNodeById(String id) {
        return this.nodeMap.get(id);
    }

    @Override
    public Collection<TreeNode> getChildren(String id) {
        TreeNode n = this.nodeMap.get(id);
        if (n != null) {
            LinkedList<TreeNode> children = new LinkedList<TreeNode>();
            for (TreeNode node : this.nodes) {
                if (!id.equals(node.getPid())) continue;
                children.add(node);
            }
            return children;
        }
        return null;
    }

    @Override
    public Collection<TreeNode> getNodes() {
        return this.nodes;
    }

    @Override
    public List<TreeNode> getNodesAsArray() {
        return Collects.asList(Collects.toArray(this.nodes, TreeNode[].class));
    }

    @Override
    public void forEach(Consumer2<Tree, TreeNode> cb) throws Throwable {
        for (TreeNode node : this.nodes) {
            cb.accept(this, node);
        }
    }

    @Override
    public TreeNode getParentNode(String treeNodeId) {
        TreeNode node = this.getNodeById(treeNodeId);
        if (node != null) {
            return this.getParentNode(node);
        }
        return null;
    }

    @Override
    public TreeNode getParentNode(TreeNode treeNode) {
        return this.getNodeById(treeNode.getPid());
    }

    @Override
    public void sort(Comparator<TreeNode> comparator) {
        Collections.sort(this.nodes, comparator);
    }

    @Override
    public List<TreeNode> getRootNodes() {
        CommonTree cTree = new CommonTree();
        cTree.addNodes(this.nodes);
        List<TreeNode> roots = cTree.getRootNodes();
        cTree.clear();
        return roots;
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.nodeMap.clear();
    }
}

