/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.stack;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.iter.ReverseListIterator;
import com.jn.langx.util.collection.stack.Stack;
import com.jn.langx.util.function.Consumer;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;

public class SimpleStack<E>
implements Stack<E> {
    protected List<E> list = Collects.emptyArrayList();

    public SimpleStack() {
    }

    public SimpleStack(Collection<E> list) {
        this();
        if (Emptys.isNotEmpty(list)) {
            this.addAll(list);
        }
    }

    @Override
    public E push(E item) {
        this.list.add(item);
        return item;
    }

    @Override
    public E pop() {
        if (!this.isEmpty()) {
            return this.list.remove(this.size() - 1);
        }
        throw new EmptyStackException();
    }

    @Override
    public E peek() {
        if (!this.isEmpty()) {
            return this.list.get(this.size() - 1);
        }
        throw new EmptyStackException();
    }

    @Override
    public int search(Object o) {
        return Collects.firstOccurrence(this, o);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReverseListIterator<E>(this.list);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.push(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Collects.forEach(c, new Consumer<E>(){

            @Override
            public void accept(E e) {
                SimpleStack.this.add(e);
            }
        });
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

