/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.sequence;

import com.jn.langx.util.Objects;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.iter.IteratorIterable;
import com.jn.langx.util.collection.sequence.Sequence;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.langx.util.struct.Holder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractCharSequence<S extends CharSequence>
implements Sequence<Character> {
    protected S charSequence;

    @Override
    public Character first() {
        return Character.valueOf(this.charSequence.charAt(0));
    }

    @Override
    public Character last() {
        return Character.valueOf(this.charSequence.charAt(this.charSequence.length() - 1));
    }

    @Override
    public boolean isNull() {
        return this.charSequence == null;
    }

    @Override
    public int size() {
        return this.charSequence.length();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharIterator((CharSequence)this.charSequence);
    }

    @Override
    public Object[] toArray() {
        List<Character> arr = this.subList(0, this.size());
        return arr.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<Character> arr = this.subList(0, this.size());
        return arr.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        final Holder<List<Character>> comparedCharsHolder = new Holder<List<Character>>(Pipeline.of(c).filter(new Predicate(){

            public boolean test(Object value) {
                return Primitives.isChar(value.getClass());
            }
        }).map(new Function<Object, Character>(){

            @Override
            public Character apply(Object input) {
                return (Character)input;
            }
        }).asList());
        if (Objects.length(c) != Objects.length(comparedCharsHolder.get())) {
            return false;
        }
        if (comparedCharsHolder.get().isEmpty()) {
            return false;
        }
        Iterator<Character> iterator = this.iterator();
        List<Character> collection = Collects.asList(new IteratorIterable<Character>(iterator));
        Collects.forEach(collection, new Consumer2<Integer, Character>(){

            @Override
            public void accept(Integer index, Character ch) {
                if (Collects.contains((Collection)comparedCharsHolder.get(), ch)) {
                    ((List)comparedCharsHolder.get()).remove(ch);
                }
            }
        }, new Predicate2<Integer, Character>(){

            @Override
            public boolean test(Integer key, Character value) {
                return comparedCharsHolder.isEmpty();
            }
        });
        return comparedCharsHolder.isEmpty();
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.charSequence.charAt(index));
    }

    @Override
    public int indexOf(Object o) {
        Iterator<Character> iter = this.iterator();
        return this.indexOfByIterator(iter, o);
    }

    private int indexOfByIterator(Iterator<Character> iter, Object o) {
        int i = -1;
        while (iter.hasNext()) {
            Character c = iter.next();
            ++i;
            if (!Objects.equals(c, o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        CharIterator iter = new CharIterator((CharSequence)this.charSequence, true);
        int index = this.indexOfByIterator(iter, o);
        if (index == -1) {
            return -1;
        }
        return Arrs.reverseIndex(this.size(), index);
    }

    @Override
    public ListIterator<Character> listIterator() {
        return new CharIterator((CharSequence)this.charSequence);
    }

    @Override
    public ListIterator<Character> listIterator(int index) {
        return new CharIterator(index, (CharSequence)this.charSequence, false);
    }

    @Override
    public List<Character> subList(int fromIndex, int toIndex) {
        int[] validIndexes = Arrs.toPositiveIndexes(this.size(), fromIndex, toIndex);
        List<Character> characters = Collects.emptyArrayList();
        for (int i = validIndexes[0]; i < validIndexes[1]; ++i) {
            characters.add(Character.valueOf(this.charSequence.charAt(i)));
        }
        return characters;
    }

    private static class CharIterator
    implements ListIterator<Character> {
        private int index = 0;
        private final int length;
        private boolean reversed;
        private CharSequence charSequence;

        CharIterator(CharSequence charSequence) {
            this(charSequence, false);
        }

        CharIterator(CharSequence charSequence, boolean reversed) {
            this(0, charSequence, reversed);
        }

        CharIterator(int index, CharSequence charSequence, boolean reversed) {
            this.charSequence = charSequence;
            this.index = index;
            this.length = charSequence.length();
            this.reversed = reversed;
        }

        @Override
        public boolean hasNext() {
            return this.reversed ? this.index >= 0 : this.index < this.length;
        }

        @Override
        public Character next() {
            if (this.hasNext()) {
                int n;
                if (this.reversed) {
                    int n2 = this.index;
                    n = n2;
                    this.index = n2 - 1;
                } else {
                    int n3 = this.index;
                    n = n3;
                    this.index = n3 + 1;
                }
                return Character.valueOf(this.charSequence.charAt(n));
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.reversed ? this.index < this.length : this.index > 0;
        }

        @Override
        public Character previous() {
            if (this.hasPrevious()) {
                int n;
                if (this.reversed) {
                    int n2 = this.index;
                    n = n2;
                    this.index = n2 + 1;
                } else {
                    int n3 = this.index;
                    n = n3;
                    this.index = n3 - 1;
                }
                return Character.valueOf(this.charSequence.charAt(n));
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            if (this.reversed) {
                return this.index - 1;
            }
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            if (this.reversed) {
                return this.index + 1;
            }
            return this.index - 1;
        }

        @Override
        public void set(Character character) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character character) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

