/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.iter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.iter.UnmodifiableIterator;
import java.util.ListIterator;

public class WrappedListIterator<E>
implements ListIterator<E> {
    private ListIterator<E> delegate;
    private boolean mutable;

    public WrappedListIterator(ListIterator delegate) {
        this(delegate, !(delegate instanceof UnmodifiableIterator));
    }

    public WrappedListIterator(ListIterator delegate, boolean mutable) {
        Preconditions.checkNotNull(delegate);
        this.delegate = delegate;
        this.mutable = mutable;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public E next() {
        return this.delegate.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public E previous() {
        return this.delegate.previous();
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public void remove() {
        if (this.mutable) {
            this.delegate.remove();
        }
    }

    @Override
    public void set(E e) {
        if (this.mutable) {
            this.delegate.set(e);
        }
    }

    @Override
    public void add(E e) {
        if (this.mutable) {
            this.delegate.add(e);
        }
    }
}

