/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.iter;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import java.util.Iterator;

public class IteratorIterable<E>
implements Iterable<E> {
    private Iterator<E> iterator;

    public IteratorIterable(@NonNull Iterator<E> iterator) {
        this(iterator, true);
    }

    public IteratorIterable(@NonNull Iterator<E> iterator, boolean removable) {
        Preconditions.checkNotNull(iterator);
        this.iterator = removable ? iterator : new UnremoveableIterator(iterator);
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    private static class UnremoveableIterator<E>
    implements Iterator<E> {
        private Iterator<E> delegate;

        private UnremoveableIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove element when using an unremovable iterator");
        }
    }
}

