/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.iter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.iter.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CompositeIterator<E>
extends UnmodifiableIterator {
    private final List<Iterator<E>> iterators = Collects.emptyArrayList();
    private int currentIteratorIndex = -1;

    public void add(Iterator<E> iterator) {
        Preconditions.checkNotNull(iterator);
        if (this.currentIteratorIndex <= -1) {
            if (this.iterators.contains(iterator)) {
                throw new IllegalArgumentException("You cannot add the same iterator twice");
            }
            this.iterators.add(iterator);
        }
    }

    @Override
    public boolean hasNext() {
        Iterator<E> currentIterator;
        if (this.iterators.isEmpty() || this.currentIteratorIndex >= this.iterators.size()) {
            return false;
        }
        if (this.currentIteratorIndex == -1) {
            this.currentIteratorIndex = 0;
        }
        if ((currentIterator = this.iterators.get(this.currentIteratorIndex)).hasNext()) {
            return true;
        }
        ++this.currentIteratorIndex;
        return this.hasNext();
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.iterators.get(this.currentIteratorIndex).next();
        }
        throw new NoSuchElementException("All iterators exhausted");
    }
}

