/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.graph;

import com.jn.langx.AbstractNameable;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.graph.Edge;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.hash.HashCodeBuilder;
import java.util.List;

public class Vertex<T>
extends AbstractNameable {
    private List<Edge<T>> incomingEdges = Collects.emptyArrayList();
    private List<Edge<T>> outgoingEdges = Collects.emptyArrayList();
    @Nullable
    private T data;

    public Vertex() {
        this(null, null);
    }

    public Vertex(String n) {
        this(n, null);
    }

    public Vertex(String n, T data) {
        this.setName(n);
        this.setData(data);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean addEdge(Edge<T> e) {
        if (e.getFrom() == this) {
            this.outgoingEdges.add(e);
        } else if (e.getTo() == this) {
            this.incomingEdges.add(e);
        } else {
            return false;
        }
        return true;
    }

    public void addOutgoingEdge(Vertex<T> to, int weight) {
        Edge<T> out = new Edge<T>(this, to, weight);
        this.addEdge(out);
    }

    public void addIncomingEdge(Vertex<T> from, int weight) {
        Edge<T> incoming = new Edge<T>(from, this, weight);
        this.addEdge(incoming);
    }

    public boolean hasEdge(Edge<T> e) {
        if (e.getFrom() == this) {
            return this.outgoingEdges.contains(e);
        }
        if (e.getTo() == this) {
            return this.incomingEdges.contains(e);
        }
        return false;
    }

    public boolean remove(Edge<T> e) {
        if (e.getFrom() == this) {
            this.outgoingEdges.remove(e);
        } else if (e.getTo() == this) {
            this.incomingEdges.remove(e);
        } else {
            return false;
        }
        return true;
    }

    public int getIncomingEdgeCount() {
        return this.incomingEdges.size();
    }

    public Edge<T> getIncomingEdge(int i) {
        return this.incomingEdges.get(i);
    }

    public List<Edge<T>> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<Vertex<T>> getIncomingVertices() {
        List<Edge<T>> edges = this.getIncomingEdges();
        return Pipeline.of(edges).map(new Function<Edge<T>, Vertex<T>>(){

            @Override
            public Vertex<T> apply(Edge<T> edge) {
                return edge.getFrom();
            }
        }).asList();
    }

    public List<String> getIncomingVertexNames() {
        return Pipeline.of(this.getIncomingVertices()).map(new Function<Vertex<T>, String>(){

            @Override
            public String apply(Vertex<T> vertex) {
                return vertex.getName();
            }
        }).asList();
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public Edge<T> getOutgoingEdge(int i) {
        return this.outgoingEdges.get(i);
    }

    public List<Edge<T>> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public List<Vertex<T>> getOutgoingVertices() {
        List<Edge<T>> edges = this.getOutgoingEdges();
        return Pipeline.of(edges).map(new Function<Edge<T>, Vertex<T>>(){

            @Override
            public Vertex<T> apply(Edge<T> edge) {
                return edge.getTo();
            }
        }).asList();
    }

    public List<String> getOutgoingVertexNames() {
        return Pipeline.of(this.getOutgoingVertices()).map(new Function<Vertex<T>, String>(){

            @Override
            public String apply(Vertex<T> vertex) {
                return vertex.getName();
            }
        }).asList();
    }

    public Edge<T> findEdge(Vertex<T> dest) {
        for (Edge<T> e : this.outgoingEdges) {
            if (e.getTo() != dest) continue;
            return e;
        }
        return null;
    }

    public Edge<T> findEdge(Edge<T> e) {
        if (this.outgoingEdges.contains(e)) {
            return e;
        }
        return null;
    }

    public int weight(Vertex<T> dest) {
        if (dest == this) {
            return 0;
        }
        Edge<T> e = this.findEdge(dest);
        int weight = Integer.MAX_VALUE;
        if (e != null) {
            weight = e.getWeight();
        }
        return weight;
    }

    public boolean hasEdge(Vertex<T> dest) {
        return this.findEdge(dest) != null;
    }

    public boolean isRoot() {
        return this.getIncomingEdgeCount() == 0;
    }

    public boolean isLeaf() {
        return this.getOutgoingEdgeCount() == 0;
    }

    public boolean isIsolated() {
        return this.isRoot() && this.isLeaf();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return Objs.equals(this.name, vertex.name);
    }

    public int hashCode() {
        return new HashCodeBuilder().with(this.name).with(this.data).build();
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("Vertex(name: ");
        tmp.append(this.name);
        tmp.append(", data:");
        tmp.append(this.data);
        tmp.append(", in:[");
        String in = Strings.join(",", Pipeline.of(this.incomingEdges).map(new Function<Edge<T>, String>(){

            @Override
            public String apply(Edge<T> e) {
                return StringTemplates.formatWithPlaceholder("{from: {}, edge_label: {}, weight:{}}", e.getFrom().getName(), e.getLabel(), e.getWeight());
            }
        }).asList());
        tmp.append(in);
        tmp.append("], out:[");
        String out = Strings.join(",", Pipeline.of(this.outgoingEdges).map(new Function<Edge<T>, String>(){

            @Override
            public String apply(Edge<T> e) {
                return StringTemplates.formatWithPlaceholder("{to: {}, edge_label: {}, weight:{}}", e.getTo().getName(), e.getLabel(), e.getWeight());
            }
        }).asList());
        tmp.append(out);
        tmp.append(']');
        tmp.append(")");
        return tmp.toString();
    }
}

