/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;

public class WheelQueue<E>
implements Queue<E> {
    private final LinkedList<E> list = new LinkedList();
    private final ReentrantLock lock = new ReentrantLock(true);

    @Override
    public boolean add(E e) {
        this.lock.lock();
        try {
            boolean bl = this.list.add(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(E e) {
        this.lock.lock();
        try {
            boolean bl = this.list.add(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E remove() {
        this.lock.lock();
        try {
            if (this.size() > 0) {
                E e = this.list.remove(0);
                return e;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E poll() {
        this.lock.lock();
        try {
            E e = this.size() > 0 ? (E)this.list.remove(0) : null;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private E get(boolean move) {
        E e;
        E e2 = e = this.size() > 0 ? (E)this.list.get(0) : null;
        if (move && null != e) {
            this.remove();
            this.add(e);
        }
        return e;
    }

    public E get() {
        this.lock.lock();
        try {
            E e = this.get(true);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E element() {
        this.lock.lock();
        try {
            E e = this.get(false);
            if (e == null) {
                throw new NoSuchElementException();
            }
            E e2 = e;
            return e2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E peek() {
        this.lock.lock();
        try {
            E e = this.get(false);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.lock.lock();
        try {
            boolean bl = this.list.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        this.lock.lock();
        try {
            Iterator iterator = this.list.iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.lock.lock();
        try {
            T[] TArray = this.list.toArray(a);
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Iterator<E> iter = this.iterator();
            while (iter.hasNext()) {
                E e = iter.next();
                if (!e.equals(o)) continue;
                iter.remove();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        this.lock.lock();
        try {
            for (Object e : c) {
                if (this.contains(e)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.lock.lock();
        try {
            boolean bl = this.list.addAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean bl = this.list.removeAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean bl = this.list.retainAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.list.clear();
        }
        finally {
            this.lock.unlock();
        }
    }
}

