/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.Ordered;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.multivalue.CommonMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.struct.Entry;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.counter.SimpleIntegerCounter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OrderedList<E extends Ordered>
extends AbstractList<E>
implements Cloneable {
    private MultiValueMap<Integer, E> map;

    public OrderedList() {
        this(new Supplier<Integer, Collection<E>>(){

            @Override
            public Collection<E> get(Integer input) {
                return new ArrayList();
            }
        });
    }

    public OrderedList(Supplier<Integer, Collection<E>> valuesSupplier) {
        this.map = new CommonMultiValueMap<Integer, E>(new TreeMap(), valuesSupplier);
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.map.total()) {
            throw new IndexOutOfBoundsException();
        }
        Entry<Integer, Integer> coordinate = this.getCoordinate(index);
        return (E)((Ordered)Collects.asList((Iterable)this.map.get(coordinate.getKey())).get((Integer)coordinate.getValue()));
    }

    private Entry<Integer, Integer> getCoordinate(final int index) {
        if (index < 0 || index >= this.map.total()) {
            throw new IndexOutOfBoundsException();
        }
        final SimpleIntegerCounter counter = new SimpleIntegerCounter();
        final Holder holder = new Holder();
        Collects.forEach(this.map, new Predicate2<Integer, Collection<E>>(){

            @Override
            public boolean test(Integer order, Collection<E> values) {
                int sum = counter.get() + values.size();
                if (sum < index) {
                    counter.increment(values.size());
                    return false;
                }
                return true;
            }
        }, new Consumer2<Integer, Collection<E>>(){

            @Override
            public void accept(Integer order, Collection<E> values) {
                int offset = index - counter.get();
                holder.set(new Entry<Integer, Integer>(order, offset));
            }
        }, new Predicate2<Integer, Collection<E>>(){

            @Override
            public boolean test(Integer order, Collection<E> values) {
                return !holder.isNull();
            }
        });
        return (Entry)holder.get();
    }

    @Override
    public E set(int index, E element) {
        Object e1 = this.remove(index);
        this.add(element);
        return (E)e1;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        this.map.add(e.getOrder(), e);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public E remove(int index) {
        Entry<Integer, Integer> coordinate = this.getCoordinate(index);
        Collection values = (Collection)this.map.get(coordinate.getKey());
        Ordered e1 = (Ordered)Collects.asList(values).get((Integer)coordinate.getValue());
        values.remove(e1);
        return (E)e1;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Ordered)) {
            return false;
        }
        Ordered e = (Ordered)o;
        Collection values = (Collection)this.map.get(e.getOrder());
        return values.remove(o);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Collects.forEach(c, new Consumer<E>(){

            @Override
            public void accept(E e) {
                OrderedList.this.add(e);
            }
        });
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Collects.forEach(c, new Consumer<E>(){

            @Override
            public void accept(E e) {
                OrderedList.this.remove(e);
            }
        });
        return true;
    }

    @Override
    public boolean retainAll(final Collection c) {
        final Set<Integer> orderSet = Pipeline.of(c).filter(new Predicate<Object>(){

            @Override
            public boolean test(Object value) {
                return value instanceof Ordered;
            }
        }).map(new Function<Ordered, Integer>(){

            @Override
            public Integer apply(Ordered e) {
                return e.getOrder();
            }
        }).asSet(false);
        Collects.forEach(new ArrayList(this.map.keySet()), new Consumer<Integer>(){

            @Override
            public void accept(Integer order) {
                if (!orderSet.contains(order)) {
                    OrderedList.this.map.remove(order);
                } else {
                    Collects.forEach(new ArrayList((Collection)OrderedList.this.map.get(order)), new Consumer<E>(){

                        @Override
                        public void accept(E e) {
                            if (!c.contains(e)) {
                                OrderedList.this.map.remove(e);
                            }
                        }
                    });
                }
            }
        });
        return true;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Entry<Integer, Integer> coordinate = this.getCoordinate(index);
        final int order = (Integer)coordinate.getKey();
        final int offset = (Integer)coordinate.getValue();
        List<Integer> orders = Pipeline.of(this.map.keySet()).filter(new Predicate<Integer>(){

            @Override
            public boolean test(Integer order2) {
                if (offset == 0) {
                    return order2 >= order;
                }
                return order2 > order;
            }
        }).asList();
        final CompositeListIterator listIterator = new CompositeListIterator();
        if (offset > 0) {
            Collection firstCollection = (Collection)this.map.get(order);
            Iterator firstIter = Collects.newArrayList(firstCollection).subList(offset, firstCollection.size()).iterator();
            listIterator.addIterator(firstIter);
        }
        Collects.forEach(orders, new Consumer<Integer>(){

            @Override
            public void accept(Integer order) {
                listIterator.addIterator(((Collection)OrderedList.this.map.get(order)).iterator());
            }
        });
        return listIterator;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int size = this.size();
        Preconditions.checkIndex(fromIndex, size);
        toIndex = Maths.min(this.map.total(), toIndex);
        Preconditions.checkIndex(toIndex, size);
        final Entry<Integer, Integer> fromCoordinate = this.getCoordinate(fromIndex);
        final int fromOrder = (Integer)fromCoordinate.getKey();
        final Entry<Integer, Integer> toCoordinate = this.getCoordinate(fromIndex);
        final int toOrder = (Integer)toCoordinate.getKey();
        final ArrayList list = new ArrayList();
        Collects.forEach(this.map.entrySet(), new Consumer2<Integer, Map.Entry<Integer, Collection<E>>>(){

            @Override
            public void accept(Integer od, Map.Entry<Integer, Collection<E>> values) {
                if (od == fromOrder) {
                    list.addAll(Collects.asList(values.getValue()).subList((Integer)fromCoordinate.getValue(), values.getValue().size()));
                } else if (od == toOrder) {
                    list.addAll(Collects.asList(values.getValue()).subList(0, (Integer)toCoordinate.getValue()));
                } else {
                    list.addAll(values.getValue());
                }
            }
        });
        return list;
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean containsAll(Collection c) {
        return Collects.allMatch(c, new Predicate(){

            public boolean test(Object obj) {
                return OrderedList.this.contains(obj);
            }
        });
    }

    @Override
    public String toString() {
        return "[" + Strings.join(",", this.toList()) + "]";
    }

    @Override
    public int size() {
        return this.map.total();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Ordered)) {
            return false;
        }
        Ordered value = (Ordered)obj;
        int order = value.getOrder();
        Collection values = (Collection)this.map.get(order);
        if (values == null) {
            return false;
        }
        return values.contains(value);
    }

    @Override
    public int indexOf(final Object o) {
        if (!(o instanceof Ordered)) {
            return -1;
        }
        final int order = ((Ordered)o).getOrder();
        if (!this.map.containsKey(order)) {
            return -1;
        }
        final SimpleIntegerCounter counter = new SimpleIntegerCounter();
        Collects.forEach(this.map.keySet(), new Consumer<Integer>(){

            @Override
            public void accept(Integer od) {
                if (od < order) {
                    counter.increment(((Collection)OrderedList.this.map.get(od)).size());
                } else {
                    counter.increment(Collects.asList((Iterable)OrderedList.this.map.get(od)).indexOf(o));
                }
            }
        }, new Predicate<Integer>(){

            @Override
            public boolean test(Integer od) {
                return od > order;
            }
        });
        return counter.get();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public Object clone() {
        final OrderedList<E> other = new OrderedList<E>();
        Collects.forEach(this.map.entrySet(), new Consumer2<Integer, Collection<E>>(){

            @Override
            public void accept(Integer order, Collection<E> values) {
                other.addAll(values);
            }
        });
        return other;
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    private List<E> toList() {
        final ArrayList list = new ArrayList();
        Collects.forEach(this.map.entrySet(), new Consumer2<Integer, Collection<E>>(){

            @Override
            public void accept(Integer order, Collection<E> values) {
                list.addAll(values);
            }
        });
        return list;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toList().toArray(a);
    }

    public void trimToSize() {
    }

    public void ensureCapacity(int minCapacity) {
    }

    private class CompositeListIterator
    implements ListIterator<E> {
        private List<Iterator<E>> iters = Collects.emptyArrayList();
        private int current = 0;

        private CompositeListIterator() {
        }

        public void addIterator(Iterator<E> iterator) {
            this.iters.add(iterator);
        }

        @Override
        public boolean hasNext() {
            if (this.current < this.iters.size()) {
                return true;
            }
            return this.iters.get(this.current).hasNext();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                return null;
            }
            if (!this.iters.get(this.current).hasNext()) {
                ++this.current;
            }
            return (Ordered)this.iters.get(this.current).next();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public E previous() {
            return null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void remove() {
            this.iters.get(this.current).remove();
        }

        @Override
        public void set(E e) {
        }

        @Override
        public void add(E e) {
        }
    }
}

