/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.function.Supplier;
import java.util.HashMap;
import java.util.Map;

public class NonAbsentHashMap<K, V>
extends HashMap<K, V> {
    private Supplier<K, V> supplier;

    public NonAbsentHashMap(@NonNull Supplier<K, V> supplier) {
        this.setSupplier(supplier);
    }

    public NonAbsentHashMap(int initialCapacity, Supplier<K, V> supplier) {
        this(initialCapacity, initialCapacity, supplier);
    }

    public NonAbsentHashMap(int initialCapacity, float loadFactor, @NonNull Supplier<K, V> supplier) {
        super(initialCapacity, loadFactor);
        this.setSupplier(supplier);
    }

    public NonAbsentHashMap(Map<? extends K, ? extends V> m, Supplier<K, V> supplier) {
        super(m);
        this.setSupplier(supplier);
    }

    private void setSupplier(Supplier<K, V> supplier) {
        Preconditions.checkNotNull(supplier);
        this.supplier = supplier;
    }

    public V get(Object key, Supplier<K, V> supplier) {
        V v = this.getIfPresent(key);
        if (v == null) {
            supplier = supplier != null ? supplier : this.supplier;
            v = this.putIfAbsent(key, supplier.get(key));
        }
        return v;
    }

    @Override
    public V get(Object key) {
        return this.get(key, null);
    }

    public V getIfPresent(Object key) {
        return super.get(key);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object v = super.get(key);
        if (v == null) {
            super.put(key, value);
            v = value;
        }
        return v;
    }
}

