/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Supplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LinkedCaseInsensitiveMap<V>
implements Map<String, V>,
Serializable,
Cloneable {
    private final LinkedHashMap<String, V> targetMap;
    private final Locale locale;

    public LinkedCaseInsensitiveMap() {
        this(null);
    }

    public LinkedCaseInsensitiveMap(@Nullable Locale locale) {
        this(16, locale);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, null);
    }

    public LinkedCaseInsensitiveMap(int initialCapacity, @Nullable Locale locale) {
        this.targetMap = new LinkedHashMap(initialCapacity);
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public LinkedCaseInsensitiveMap(Map<String, V> other, Locale locale) {
        this(other.size(), locale);
        Collects.forEach(other, new Consumer2<String, V>(){

            @Override
            public void accept(String key, V value) {
                LinkedCaseInsensitiveMap.this.put(key, value);
            }
        });
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && this.targetMap.containsKey(this.convertKey((String)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.convertKey((String)key)) != null) {
            return this.targetMap.get(caseInsensitiveKey);
        }
        return null;
    }

    @Override
    @Nullable
    public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    @Override
    @Nullable
    public V put(String key, @Nullable V value) {
        String internalKey = this.convertKey(key);
        return this.targetMap.put(internalKey, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        if (map.isEmpty()) {
            return;
        }
        Collects.forEach(map, new Consumer2<String, V>(){

            @Override
            public void accept(String key, V value) {
                LinkedCaseInsensitiveMap.this.put(key, value);
            }
        });
    }

    @Override
    @Nullable
    public V remove(Object key) {
        String caseInsensitiveKey;
        if (key instanceof String && (caseInsensitiveKey = this.convertKey((String)key)) != null) {
            return this.targetMap.remove(caseInsensitiveKey);
        }
        return null;
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    @Nullable
    public V putIfAbsent(String key, @Nullable V value) {
        String internalKey = this.convertKey(key);
        V oldValue = this.targetMap.get(internalKey);
        if (oldValue == null) {
            this.targetMap.put(internalKey, value);
        }
        return oldValue;
    }

    @Nullable
    public V supplyIfAbsent(String key, @NonNull Supplier<? super String, ? extends V> supplier) {
        String internalKey = this.convertKey(key);
        V oldValue = this.targetMap.get(internalKey);
        if (oldValue == null) {
            this.targetMap.put(internalKey, supplier.get(key));
        }
        return oldValue;
    }

    @Override
    public Set<String> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.targetMap.entrySet();
    }

    public LinkedCaseInsensitiveMap<V> clone() {
        return new LinkedCaseInsensitiveMap<V>(this.targetMap, this.locale);
    }

    @Override
    public boolean equals(Object obj) {
        return this.targetMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String convertKey(String key) {
        return key.toLowerCase(this.getLocale());
    }

    protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
        return false;
    }
}

