/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.boundary;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.boundary.Boundary;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import java.util.List;

public class CommonBoundary
implements Boundary {
    private List<Predicate<String>> predicates = Collects.emptyArrayList();

    @Override
    public boolean test(final String value) {
        Preconditions.checkNotEmpty(this.predicates);
        return Collects.allMatch(this.predicates, new Predicate<Predicate<String>>(){

            @Override
            public boolean test(Predicate<String> predicate) {
                return predicate.test(value);
            }
        });
    }

    public void addPredicate(Predicate<String> predicate) {
        if (predicate != null) {
            this.predicates.add(predicate);
        }
    }

    protected List<Predicate<String>> getPredicates() {
        return this.predicates;
    }
}

