/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.bloom;

import com.jn.langx.util.io.WritableComparable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Key
implements WritableComparable<Key> {
    byte[] bytes;
    double weight;

    public Key() {
    }

    public Key(byte[] value) {
        this(value, 1.0);
    }

    public Key(byte[] value, double weight) {
        this.set(value, weight);
    }

    public void set(byte[] value, double weight) {
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        this.bytes = value;
        this.weight = weight;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public double getWeight() {
        return this.weight;
    }

    public void incrementWeight(double weight) {
        this.weight += weight;
    }

    public void incrementWeight() {
        this.weight += 1.0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Key)) {
            return false;
        }
        return this.compareTo((Key)o) == 0;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.bytes.length; ++i) {
            result ^= Byte.valueOf(this.bytes[i]).hashCode();
        }
        return result ^= Double.valueOf(this.weight).hashCode();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.bytes.length);
        out.write(this.bytes);
        out.writeDouble(this.weight);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.bytes = new byte[in.readInt()];
        in.readFully(this.bytes);
        this.weight = in.readDouble();
    }

    @Override
    public int compareTo(Key other) {
        int result = this.bytes.length - other.getBytes().length;
        for (int i = 0; result == 0 && i < this.bytes.length; ++i) {
            result = this.bytes[i] - other.bytes[i];
        }
        if (result == 0) {
            result = Double.valueOf(this.weight - other.weight).intValue();
        }
        return result;
    }
}

