/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.bloom;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.bloom.Filter;
import com.jn.langx.util.bloom.Key;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;

public class BloomFilter
extends Filter {
    private static final byte[] bitvalues = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    BitSet bits;

    public BloomFilter() {
    }

    public BloomFilter(int vectorSize, int nbHash, int hashType) {
        super(vectorSize, nbHash, hashType);
        this.bits = new BitSet(this.vectorSize);
    }

    @Override
    public void add(Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            this.bits.set(h[i]);
        }
    }

    @Override
    public void and(Filter filter) {
        if (filter == null || !(filter instanceof BloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        this.bits.and(((BloomFilter)filter).bits);
    }

    @Override
    public boolean membershipTest(@NonNull Key key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        int[] h = this.hash.hash(key);
        this.hash.clear();
        for (int i = 0; i < this.nbHash; ++i) {
            if (this.bits.get(h[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void not() {
        this.bits.flip(0, this.vectorSize - 1);
    }

    @Override
    public void or(Filter filter) {
        if (filter == null || !(filter instanceof BloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        this.bits.or(((BloomFilter)filter).bits);
    }

    @Override
    public void xor(Filter filter) {
        if (filter == null || !(filter instanceof BloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be xor-ed");
        }
        this.bits.xor(((BloomFilter)filter).bits);
    }

    public String toString() {
        return this.bits.toString();
    }

    public int getVectorSize() {
        return this.vectorSize;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        byte[] bytes = new byte[this.getNBytes()];
        int i = 0;
        int byteIndex = 0;
        int bitIndex = 0;
        while (i < this.vectorSize) {
            if (bitIndex == 8) {
                bitIndex = 0;
                ++byteIndex;
            }
            if (bitIndex == 0) {
                bytes[byteIndex] = 0;
            }
            if (this.bits.get(i)) {
                int n = byteIndex;
                bytes[n] = (byte)(bytes[n] | bitvalues[bitIndex]);
            }
            ++i;
            ++bitIndex;
        }
        out.write(bytes);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.bits = new BitSet(this.vectorSize);
        byte[] bytes = new byte[this.getNBytes()];
        in.readFully(bytes);
        int i = 0;
        int byteIndex = 0;
        int bitIndex = 0;
        while (i < this.vectorSize) {
            if (bitIndex == 8) {
                bitIndex = 0;
                ++byteIndex;
            }
            if ((bytes[byteIndex] & bitvalues[bitIndex]) != 0) {
                this.bits.set(i);
            }
            ++i;
            ++bitIndex;
        }
    }

    private int getNBytes() {
        return (this.vectorSize + 7) / 8;
    }
}

