/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.function.Consumer;

public class DoubleStatistics
implements Consumer<Double> {
    private long count;
    private double sum;
    private double sumCompensation;
    private double simpleSum;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;

    @Override
    public void accept(Double value) {
        if (value == null) {
            value = 0.0;
        }
        ++this.count;
        this.simpleSum += value.doubleValue();
        this.sumWithCompensation(value);
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    public void combine(DoubleStatistics other) {
        this.count += other.count;
        this.simpleSum += other.simpleSum;
        this.sumWithCompensation(other.sum);
        this.sumWithCompensation(other.sumCompensation);
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    private void sumWithCompensation(double value) {
        double tmp = value - this.sumCompensation;
        double velvel = this.sum + tmp;
        this.sumCompensation = velvel - this.sum - tmp;
        this.sum = velvel;
    }

    public final long getCount() {
        return this.count;
    }

    public final double getSum() {
        double tmp = this.sum + this.sumCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSum)) {
            return this.simpleSum;
        }
        return tmp;
    }

    public final double getMin() {
        return this.min;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getAverage() {
        return this.getCount() > 0L ? this.getSum() / (double)this.getCount() : 0.0;
    }

    public String toString() {
        return String.format("%s{count=%d, sum=%f, min=%f, average=%f, max=%f}", this.getClass().getSimpleName(), this.getCount(), this.getSum(), this.getMin(), this.getAverage(), this.getMax());
    }
}

