/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Calendars;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.struct.Holder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class Dates {
    public static final int MINUTES_TO_SECONDS = 60;
    public static final int HOURS_TO_SECONDS = 3600;
    public static final int DAY_TO_SECONDS = 86400;
    public static final long SECONDS_TO_MILLIS = 1000L;
    public static final long MINUTES_TO_MILLIS = 60000L;
    public static final long HOURS_TO_MILLIS = 3600000L;
    public static final long DAY_TO_MILLIS = 86400000L;
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String yyyy_MM_dd = "yyyy-MM-dd";
    public static final String yyyy_MM_dd_1 = "yyyy-M-d";
    public static final String yyyy_MM_dd_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String yyyy_MM_dd_CN_1 = "yyyy\u5e74M\u6708d\u65e5";
    public static final String dd_MM_yyyy = "dd/MM/yyyy";
    public static final String MM_dd_yyyy = "MM/dd/yyyy";
    public static final String MM_dd_yyyy_1 = "M/d/yyyy";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String yyyy_MM_dd_HH_mm_ss = "yyyy-MM-dd HH:mm:ss";
    public static final String yyyy_MM_dd_HH_mm_ss_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String yyyy_MM_dd_T_HH_mm_ss = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String yyyy_MM_dd_T_HH_mm_ssZone = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String HH_mm_ss = "HH:mm:ss";
    public static final String HH_mm_ss_CN = "HH\u65f6mm\u5206ss\u79d2";
    public static final String HH_MM_ssZone = "HH:mm:ssZZ";
    public static final char[] DATE_FORMAT_FLAGS = new char[]{'G', 'y', 'Y', 'M', 'w', 'W', 'D', 'd', 'F', 'E', 'u', 'a', 'H', 'k', 'K', 'h', 'm', 's', 'S', 'z', 'Z', 'X'};

    public static String format(long millis, @NonNull String pattern) {
        Preconditions.checkTrue(millis >= 0L);
        return Dates.format(new Date(millis), pattern);
    }

    public static String format(@NonNull Date date) {
        return Dates.format(date, yyyy_MM_dd_HH_mm_ss);
    }

    public static String format(@NonNull Date date, @NotEmpty String pattern) {
        Preconditions.checkNotEmpty(pattern, "pattern is empty");
        Preconditions.checkNotNull(date);
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern).format(date);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable Locale locale) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, locale);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable TimeZone timeZone) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZone);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable String timeZoneId) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZoneId);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable TimeZone timeZone, @Nullable Locale locale) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZone, locale);
    }

    public static SimpleDateFormat getSimpleDateFormat(@NotEmpty String pattern, @Nullable String timeZoneId, @Nullable Locale locale) {
        return GlobalThreadLocalMap.getSimpleDateFormat(pattern, timeZoneId, locale);
    }

    public static Date parse(String dateString, @NotEmpty String pattern) {
        return Dates.parse(dateString, new String[]{pattern});
    }

    public static Date parse(String dateString, String ... patterns) {
        return Dates.parse(dateString, Collects.asList(patterns));
    }

    public static Date parse(final String dateString, List<String> patterns) {
        final Holder ret = new Holder();
        Collects.forEach(patterns, new Consumer<String>(){

            @Override
            public void accept(String pattern) {
                try {
                    Date date = GlobalThreadLocalMap.getSimpleDateFormat(pattern).parse(dateString);
                    ret.set(date);
                }
                catch (ParseException ex) {
                    throw Throwables.wrapAsRuntimeException(ex);
                }
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String pattern) {
                return !ret.isEmpty();
            }
        });
        return (Date)ret.get();
    }

    public static Date addYears(Date date, int amount) {
        return Dates.add(date, Calendars.YEAR, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return Dates.add(date, Calendars.MONTH, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return Dates.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return Dates.add(date, Calendars.DAY, amount);
    }

    public static Date addHours(Date date, int amount) {
        return Dates.add(date, Calendars.HOUR, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return Dates.add(date, Calendars.MINUTE, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return Dates.add(date, Calendars.SECOND, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return Dates.add(date, Calendars.MILLIS, amount);
    }

    public static Date add(Date date, int calendarField, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date add(Date date, Calendars.DateField calendarField, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendars.addField(c, calendarField, amount);
        return c.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return Dates.set(date, Calendars.YEAR, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return Dates.setMonths(date, amount, false);
    }

    public static Date setMonths(Date date, int amount, boolean valueIsActual) {
        return Dates.set(date, Calendars.MONTH, valueIsActual ? amount - 1 : amount);
    }

    public static Date setDays(Date date, int amount) {
        return Dates.set(date, Calendars.DAY, amount);
    }

    public static Date setHours(Date date, int amount) {
        return Dates.set(date, Calendars.HOUR, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return Dates.set(date, Calendars.MINUTE, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return Dates.set(date, Calendars.SECOND, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return Dates.set(date, Calendars.DateField.MILLIS, amount);
    }

    public static Date set(Date date, Calendars.DateField field, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        Calendars.setField(c, field, amount);
        return c.getTime();
    }

    public static int get(@NonNull Date date, Calendars.DateField field) {
        return Calendars.getField(Dates.toCalendar(date), field);
    }

    public static int getYears(@NonNull Date date) {
        return Calendars.getYears(Dates.toCalendar(date));
    }

    public static int getMonths(@NonNull Date date) {
        return Dates.getMonths(date, false);
    }

    public static int getMonths(@NonNull Date date, boolean getActualMonth) {
        return Calendars.getMonths(Dates.toCalendar(date), getActualMonth);
    }

    public static int getDays(@NonNull Date date) {
        return Calendars.getDays(Dates.toCalendar(date));
    }

    public static int getHours(@NonNull Date date) {
        return Calendars.getHours(Dates.toCalendar(date));
    }

    public static int getMinutes(@NonNull Date date) {
        return Calendars.getMinutes(Dates.toCalendar(date));
    }

    public static int getSeconds(@NonNull Date date) {
        return Calendars.getSeconds(Dates.toCalendar(date));
    }

    public static int getMillis(@NonNull Date date) {
        return Calendars.getMillis(Dates.toCalendar(date));
    }

    public static long nextTime(long baselineInMills, long durationInMills) {
        Preconditions.checkTrue(baselineInMills >= 0L);
        Preconditions.checkTrue(durationInMills >= 0L);
        if (Long.MAX_VALUE - baselineInMills <= durationInMills) {
            return Long.MAX_VALUE;
        }
        return baselineInMills + durationInMills;
    }

    public static long nextTime(long durationInMills) {
        if (durationInMills < 0L) {
            return Long.MAX_VALUE;
        }
        return Dates.nextTime(System.currentTimeMillis(), durationInMills);
    }

    public static long nowMills() {
        return System.currentTimeMillis();
    }

    public static Date now() {
        return new Date();
    }

    public static String nowReadableString() {
        return Dates.format(new Date(), yyyy_MM_dd_HH_mm_ss);
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(Date date, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(date);
        return c;
    }

    public static TimeZone localTimeZone() {
        return TimeZone.getDefault();
    }
}

