/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.DataUnit;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import java.util.regex.Pattern;

public final class DataSize {
    public static final DataSize ZERO = new DataSize(0L);
    private final long value;
    private final DataUnit unit;
    private static final Pattern MEM_SIZE_PATTERN = Pattern.compile("\\s*\\d+(\\.\\d+)?\\s*[gmktp]?b\\s*", 2);

    public DataSize(long value, DataUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public DataSize(long bytes) {
        this.value = bytes;
        this.unit = DataUnit.B;
    }

    public int toInt() {
        long bytes = this.getBytes();
        if (bytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("MemSize exceeds Integer.MAX_VALUE: " + bytes);
        }
        return (int)bytes;
    }

    public long getBytes() {
        return this.value * this.unit.getBytes();
    }

    @NonNull
    public static DataSize of(long bytes) {
        return new DataSize(bytes);
    }

    public static DataSize of(long value, DataUnit unit) {
        return new DataSize(value, unit);
    }

    @NonNull
    public static DataSize bytes(long bytes) {
        return DataSize.of(bytes);
    }

    @NonNull
    public static DataSize kb(long kb) {
        return DataSize.of(kb, DataUnit.KB);
    }

    @NonNull
    public static DataSize mb(long mb) {
        return DataSize.of(mb, DataUnit.MB);
    }

    @NonNull
    public static DataSize gb(long gb) {
        return DataSize.of(gb, DataUnit.GB);
    }

    @NonNull
    public static DataSize tb(long tb) {
        return DataSize.of(tb, DataUnit.TB);
    }

    public static DataSize pb(long pb) {
        return DataSize.of(pb, DataUnit.PB);
    }

    @NonNull
    public static DataSize valueOf(@NonNull String string) {
        return DataSize.parseMemSize(string);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSize memSize = (DataSize)o;
        return this.getBytes() == memSize.getBytes();
    }

    public int hashCode() {
        return this.unit.hashCode() << (int)(2L + this.value);
    }

    @NonNull
    public String toString() {
        return "" + this.getBytes();
    }

    public static DataSize parseMemSize(String memSizeString) {
        Preconditions.checkNotNull(memSizeString);
        if (!MEM_SIZE_PATTERN.matcher(memSizeString).matches()) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("{} is not an illegal data size", memSizeString));
        }
        final String lowerCase = memSizeString.trim().toLowerCase();
        String unit = Collects.findFirst(DataUnit.allSymbols(), new Predicate<String>(){

            @Override
            public boolean test(String unit) {
                return lowerCase.endsWith(unit);
            }
        });
        memSizeString = lowerCase.substring(0, lowerCase.length() - (Strings.isEmpty(unit) ? 0 : unit.length())).trim();
        if (Strings.isEmpty(unit)) {
            unit = "b";
        }
        String[] segments = Strings.split(memSizeString, ".");
        DataUnit dataunit = DataUnit.ofSymbol(unit);
        if (segments.length == 1 || dataunit == DataUnit.B) {
            return DataSize.of(dataunit.getBytes() * Long.parseLong(segments[0]));
        }
        DataUnit nextLevelUnit = DataUnit.ofBytes(dataunit.getBytes() / 1024L);
        return DataSize.of(dataunit.getBytes() * Long.parseLong(segments[0]) + nextLevelUnit.getBytes() * Long.parseLong(segments[1]));
    }
}

