/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.enums.base.EnumDelegate;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class Calendars {
    private static int[] arr = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static String[] week_cn = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private static int[] DAY_OF_WEEK = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final DateField ERA = DateField.ERA;
    public static final DateField YEAR = DateField.YEAR;
    public static final DateField MONTH = DateField.MONTH;
    public static final DateField DAY = DateField.DAY;
    public static final DateField HOUR = DateField.HOUR;
    public static final DateField MINUTE = DateField.MINUTE;
    public static final DateField SECOND = DateField.SECOND;
    public static final DateField MILLIS = DateField.MILLIS;

    private static int getNumberOfFirstDayInMonth(int year, int month) {
        if (month < 3) {
            --year;
            month += 12;
        }
        int y = year % 100;
        int m = month;
        int result = (1 + 2 * m + 3 * (m + 1) / 5 + y + y / 4 - y / 100 + y / 400) % 7 + 1;
        return result;
    }

    private static boolean isLeapYear(int year) {
        return year % 400 == 0 ? false : year % 4 == 0 || year % 100 == 0;
    }

    public static int getMaxDay(int year, int month) {
        return month == 2 && Calendars.isLeapYear(year) ? 29 : arr[month - 1];
    }

    public static int getNumberInWeek(int year, int month, int day) {
        return (Calendars.getNumberOfFirstDayInMonth(year, month) + day - 1) % 7;
    }

    public static int getField(@NonNull Calendar calendar, @NonNull DateField field) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        return Calendars.getField(calendar, field.getField());
    }

    public static int getField(@NonNull Calendar calendar, @NonNull int field) {
        return calendar.get(field);
    }

    public static int getYears(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, YEAR);
    }

    public static int getMonths(@NonNull Calendar calendar) {
        return Calendars.getMonths(calendar, false);
    }

    public static int getMonths(@NonNull Calendar calendar, boolean actual) {
        int month = Calendars.getField(calendar, MONTH);
        return actual ? month + 1 : month;
    }

    public static int getDays(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DAY);
    }

    public static int getHours(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, HOUR);
    }

    public static int getMinutes(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, MINUTE);
    }

    public static int getSeconds(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, SECOND);
    }

    public static int getMillis(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, MILLIS);
    }

    public static void setField(@NonNull Calendar calendar, @NonNull DateField field, int value) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        calendar.set(field.getField(), value);
        calendar.getTimeInMillis();
    }

    public static void setYears(@NonNull Calendar calendar, int year) {
        Preconditions.checkTrue(year >= 1970);
        Calendars.setField(calendar, YEAR, year);
    }

    public static void setMonths(@NonNull Calendar calendar, int month) {
        Calendars.setMonths(calendar, month, false);
    }

    public static void setMonths(@NonNull Calendar calendar, int month, boolean valueIsActual) {
        month = valueIsActual ? month - 1 : month;
        Calendars.setField(calendar, MONTH, month);
    }

    public static void setDays(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, YEAR, year);
    }

    public static void setHours(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, YEAR, year);
    }

    public static void setMinutes(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, YEAR, year);
    }

    public static void setSeconds(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, SECOND, year);
    }

    public static void setMillis(@NonNull Calendar calendar, int millis) {
        Calendars.setField(calendar, MILLIS, millis);
    }

    public static void addField(@NonNull Calendar calendar, @NonNull DateField field, int value) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        calendar.add(field.getField(), value);
        calendar.getTimeInMillis();
    }

    public static void rollField(@NonNull Calendar calendar, @NonNull DateField field, int value) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        calendar.roll(field.getField(), value);
        calendar.getTimeInMillis();
    }

    private static enum WeekType {
        MONDAY_TO_SUNDAY(Locale.CHINA, Locale.CHINESE),
        SUNDAY_TO_SATUREDAY(Locale.ENGLISH, Locale.JAPAN, Locale.JAPANESE, Locale.US, Locale.UK),
        SATUREDAY_TO_Friday(new Locale[0]);

        private List<Locale> locales;

        private WeekType(Locale ... locales) {
            this.locales = Collects.asList(locales);
        }
    }

    public static enum RecentIntervalType {
        NATURE_INTERVAL,
        TO_YESTERDAY,
        TO_NOW;

    }

    public static enum DateField implements CommonEnum
    {
        ERA(0, "era", "\u4e16\u7eaa"),
        YEAR(1, "year", "\u5e74"),
        MONTH(2, "month", "\u6708"),
        WEEK_OF_YEAR(3, "week_of_year", "\u5468"),
        WEEK_OF_MONTH(4, "week_of_month", "\u5468"),
        DAY(5, "day", "\u65e5"),
        DAY_OF_YEAR(6, "day_of_year", "\u5929"),
        DAY_OF_WEEK(7, "day_of_week", "\u661f\u671f"),
        HOUR(11, "hour", "\u65f6"),
        MINUTE(12, "minute", "\u5206"),
        SECOND(13, "second", "\u79d2"),
        MILLIS(14, "millisecond", "\u6beb\u79d2");

        private EnumDelegate enumDelegate;

        private DateField(int code, String name, String displayText) {
            this.enumDelegate = new EnumDelegate(code, name, displayText);
        }

        public int getField() {
            return this.getCode();
        }

        @Override
        public int getCode() {
            return this.enumDelegate.getCode();
        }

        @Override
        public String getName() {
            return this.enumDelegate.getName();
        }

        @Override
        public String getDisplayText() {
            return this.enumDelegate.getDisplayText();
        }
    }
}

