/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Chars;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class Bytes {
    public static final byte SPACE = 32;
    public static final byte TAB = 9;
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;

    private Bytes() {
    }

    public static long fromLittleEndian(byte[] bytes) {
        return Bytes.fromLittleEndian(bytes, 0, bytes.length);
    }

    public static long fromLittleEndian(byte[] bytes, int off, int length) {
        Bytes.checkReadLength(length);
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            l |= ((long)bytes[off + i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public static long fromLittleEndian(InputStream in, int length) throws IOException {
        Bytes.checkReadLength(length);
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            long b = in.read();
            if (b == -1L) {
                throw new IOException("premature end of data");
            }
            l |= b << i * 8;
        }
        return l;
    }

    public static long fromLittleEndian(ByteSupplier supplier, int length) throws IOException {
        Bytes.checkReadLength(length);
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            long b = supplier.getAsByte();
            if (b == -1L) {
                throw new IOException("premature end of data");
            }
            l |= b << i * 8;
        }
        return l;
    }

    public static long fromLittleEndian(DataInput in, int length) throws IOException {
        Bytes.checkReadLength(length);
        long l = 0L;
        for (int i = 0; i < length; ++i) {
            long b = in.readUnsignedByte();
            l |= b << i * 8;
        }
        return l;
    }

    public static void toLittleEndian(byte[] b, long value, int off, int length) {
        long num = value;
        for (int i = 0; i < length; ++i) {
            b[off + i] = (byte)(num & 0xFFL);
            num >>= 8;
        }
    }

    public static long littleEndianValue(byte[] bytes, int offset, int length) {
        long value = 0L;
        for (int i = length - 1; i >= 0; --i) {
            value = value << 8 | (long)(bytes[offset + i] & 0xFF);
        }
        return value;
    }

    public static void toLittleEndian(OutputStream out, long value, int length) throws IOException {
        long num = value;
        for (int i = 0; i < length; ++i) {
            out.write((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static void toLittleEndian(ByteConsumer consumer, long value, int length) throws IOException {
        long num = value;
        for (int i = 0; i < length; ++i) {
            consumer.accept((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static void toLittleEndian(DataOutput out, long value, int length) throws IOException {
        long num = value;
        for (int i = 0; i < length; ++i) {
            out.write((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static byte toLowerCase(byte c) {
        return Chars.isUpperCase(c) ? (byte)(c + 32) : c;
    }

    public static byte toUpperCase(byte b) {
        return Chars.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    public static boolean isLowerCase(byte value) {
        return value >= 97 && value <= 122;
    }

    public static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    private static void checkReadLength(int length) {
        if (length > 8) {
            throw new IllegalArgumentException("can't read more than eight bytes into a long value");
        }
    }

    public static short bigEndianToShort(byte[] bs, int off) {
        int n = (bs[off] & 0xFF) << 8;
        return (short)(n |= bs[++off] & 0xFF);
    }

    public static int bigEndianToInt(byte[] bs, int off) {
        int n = bs[off] << 24;
        n |= (bs[++off] & 0xFF) << 16;
        n |= (bs[++off] & 0xFF) << 8;
        return n |= bs[++off] & 0xFF;
    }

    public static void bigEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Bytes.bigEndianToInt(bs, off);
            off += 4;
        }
    }

    public static int bigEndianToInt(byte b, byte b2, byte b3, byte b4) {
        return b << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | b3 << 8 & 0xFF00 | b4 & 0xFF;
    }

    public static byte[] intToBigEndian(int n) {
        byte[] bs = new byte[4];
        Bytes.intToBigEndian(n, bs, 0);
        return bs;
    }

    public static void intToBigEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 24);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static byte[] intToBigEndian(int[] ns) {
        byte[] bs = new byte[4 * ns.length];
        Bytes.intToBigEndian(ns, bs, 0);
        return bs;
    }

    public static void intToBigEndian(int[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            Bytes.intToBigEndian(ns[i], bs, off);
            off += 4;
        }
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = Bytes.bigEndianToInt(bs, off);
        int lo = Bytes.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void bigEndianToLong(byte[] bs, int off, long[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Bytes.bigEndianToLong(bs, off);
            off += 8;
        }
    }

    public static byte[] longToBigEndian(long n) {
        byte[] bs = new byte[8];
        Bytes.longToBigEndian(n, bs, 0);
        return bs;
    }

    public static void longToBigEndian(long n, byte[] bs, int off) {
        Bytes.intToBigEndian((int)(n >>> 32), bs, off);
        Bytes.intToBigEndian((int)(n & 0xFFFFFFFFL), bs, off + 4);
    }

    public static byte[] longToBigEndian(long[] ns) {
        byte[] bs = new byte[8 * ns.length];
        Bytes.longToBigEndian(ns, bs, 0);
        return bs;
    }

    public static void longToBigEndian(long[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            Bytes.longToBigEndian(ns[i], bs, off);
            off += 8;
        }
    }

    public static void longToBigEndian(long value, byte[] bs, int off, int bytes) {
        for (int i = bytes - 1; i >= 0; --i) {
            bs[i + off] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
    }

    public static short littleEndianToShort(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        return (short)(n |= (bs[++off] & 0xFF) << 8);
    }

    public static int littleEndianToInt(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    public static void littleEndianToInt(byte[] bs, int off, int[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Bytes.littleEndianToInt(bs, off);
            off += 4;
        }
    }

    public static void littleEndianToInt(byte[] bs, int bOff, int[] ns, int nOff, int count) {
        for (int i = 0; i < count; ++i) {
            ns[nOff + i] = Bytes.littleEndianToInt(bs, bOff);
            bOff += 4;
        }
    }

    public static int[] littleEndianToInt(byte[] bs, int off, int count) {
        int[] ns = new int[count];
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Bytes.littleEndianToInt(bs, off);
            off += 4;
        }
        return ns;
    }

    public static byte[] shortToLittleEndian(short n) {
        byte[] bs = new byte[2];
        Bytes.shortToLittleEndian(n, bs, 0);
        return bs;
    }

    public static void shortToLittleEndian(short n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
    }

    public static byte[] shortToBigEndian(short n) {
        byte[] r = new byte[2];
        Bytes.shortToBigEndian(n, r, 0);
        return r;
    }

    public static void shortToBigEndian(short n, byte[] bs, int off) {
        bs[off] = (byte)(n >>> 8);
        bs[++off] = (byte)n;
    }

    public static byte[] intToLittleEndian(int n) {
        byte[] bs = new byte[4];
        Bytes.intToLittleEndian(n, bs, 0);
        return bs;
    }

    public static void intToLittleEndian(int n, byte[] bs, int off) {
        bs[off] = (byte)n;
        bs[++off] = (byte)(n >>> 8);
        bs[++off] = (byte)(n >>> 16);
        bs[++off] = (byte)(n >>> 24);
    }

    public static byte[] intToLittleEndian(int[] ns) {
        byte[] bs = new byte[4 * ns.length];
        Bytes.intToLittleEndian(ns, bs, 0);
        return bs;
    }

    public static void intToLittleEndian(int[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            Bytes.intToLittleEndian(ns[i], bs, off);
            off += 4;
        }
    }

    public static long littleEndianToLong(byte[] bs, int off) {
        int lo = Bytes.littleEndianToInt(bs, off);
        int hi = Bytes.littleEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void littleEndianToLong(byte[] bs, int off, long[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = Bytes.littleEndianToLong(bs, off);
            off += 8;
        }
    }

    public static void littleEndianToLong(byte[] bs, int bsOff, long[] ns, int nsOff, int nsLen) {
        for (int i = 0; i < nsLen; ++i) {
            ns[nsOff + i] = Bytes.littleEndianToLong(bs, bsOff);
            bsOff += 8;
        }
    }

    public static byte[] longToLittleEndian(long n) {
        byte[] bs = new byte[8];
        Bytes.longToLittleEndian(n, bs, 0);
        return bs;
    }

    public static void longToLittleEndian(long n, byte[] bs, int off) {
        Bytes.intToLittleEndian((int)(n & 0xFFFFFFFFL), bs, off);
        Bytes.intToLittleEndian((int)(n >>> 32), bs, off + 4);
    }

    public static byte[] longToLittleEndian(long[] ns) {
        byte[] bs = new byte[8 * ns.length];
        Bytes.longToLittleEndian(ns, bs, 0);
        return bs;
    }

    public static void longToLittleEndian(long[] ns, byte[] bs, int off) {
        for (int i = 0; i < ns.length; ++i) {
            Bytes.longToLittleEndian(ns[i], bs, off);
            off += 8;
        }
    }

    public static void longToLittleEndian(long[] ns, int nsOff, int nsLen, byte[] bs, int bsOff) {
        for (int i = 0; i < nsLen; ++i) {
            Bytes.longToLittleEndian(ns[nsOff + i], bs, bsOff);
            bsOff += 8;
        }
    }

    public static byte[] toBytes(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        buffer.flip();
        return buffer.array();
    }

    public static byte[] toBytes(double value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putDouble(value);
        buffer.flip();
        return buffer.array();
    }

    public static byte[] toBytes(float value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putFloat(value);
        buffer.flip();
        return buffer.array();
    }

    public static byte[] toBytes(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        buffer.flip();
        return buffer.array();
    }

    public static byte[] toBytes(short value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putShort(value);
        buffer.flip();
        return buffer.array();
    }

    public static byte[] toBytes(char value) {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putChar(value);
        buffer.flip();
        return buffer.array();
    }

    public static class OutputStreamByteConsumer
    implements ByteConsumer {
        private final OutputStream os;

        public OutputStreamByteConsumer(OutputStream os) {
            this.os = os;
        }

        @Override
        public void accept(int b) throws IOException {
            this.os.write(b);
        }
    }

    public static class InputStreamByteSupplier
    implements ByteSupplier {
        private final InputStream is;

        public InputStreamByteSupplier(InputStream is) {
            this.is = is;
        }

        @Override
        public int getAsByte() throws IOException {
            return this.is.read();
        }
    }

    public static interface ByteConsumer {
        public void accept(int var1) throws IOException;
    }

    public static interface ByteSupplier {
        public int getAsByte() throws IOException;
    }
}

