/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.AbstractAccessor;
import com.jn.langx.exception.IllegalValueException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Numbers;

public abstract class BasedStringAccessor<K, T>
extends AbstractAccessor<K, T> {
    @Override
    public abstract Object get(K var1);

    @Override
    public boolean has(K key) {
        return this.get(key) != null;
    }

    @Override
    public String getString(K key) {
        return this.getString(key, (String)null);
    }

    @Override
    public abstract String getString(K var1, String var2);

    @Override
    public Character getCharacter(K key) {
        return this.getCharacter(key, (Character)null);
    }

    @Override
    public Character getCharacter(K key, Character defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.length() != 1) {
            throw new IllegalValueException(StringTemplates.formatWithPlaceholder("'{}' is a string not a character", value));
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public Byte getByte(K key) {
        return this.getByte(key, (Byte)null);
    }

    @Override
    public Byte getByte(K key, Byte defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return this.getNumber(value).byteValue();
    }

    protected Number getNumber(String string) {
        return Numbers.createNumber(string);
    }

    @Override
    public Integer getInteger(K key) {
        return this.getInteger(key, (Integer)null);
    }

    @Override
    public Integer getInteger(K key, Integer defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return this.getNumber(value).intValue();
    }

    @Override
    public Short getShort(K key) {
        return this.getShort(key, (Short)null);
    }

    @Override
    public Short getShort(K key, Short defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return this.getNumber(value).shortValue();
    }

    @Override
    public Double getDouble(K key) {
        return this.getDouble(key, (Double)null);
    }

    @Override
    public Double getDouble(K key, Double defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return this.getNumber(value).doubleValue();
    }

    @Override
    public Float getFloat(K key) {
        return this.getFloat(key, (Float)null);
    }

    @Override
    public Float getFloat(K key, Float defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.valueOf(this.getNumber(value).floatValue());
    }

    @Override
    public Long getLong(K key) {
        return this.getLong(key, (Long)null);
    }

    @Override
    public Long getLong(K key, Long defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return this.getNumber(value).longValue();
    }

    @Override
    public Boolean getBoolean(K key) {
        return this.getBoolean(key, (Boolean)null);
    }

    @Override
    public Boolean getBoolean(K key, Boolean defaultValue) {
        String value = this.getString(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public abstract void set(K var1, Object var2);

    @Override
    public void setString(K key, String value) {
        this.set(key, value);
    }

    @Override
    public void setByte(K key, byte value) {
        this.set(key, value);
    }

    @Override
    public void setShort(K key, short value) {
        this.set(key, value);
    }

    @Override
    public void setInteger(K key, int value) {
        this.set(key, value);
    }

    @Override
    public void setLong(K key, long value) {
        this.set(key, value);
    }

    @Override
    public void setFloat(K key, float value) {
        this.set(key, Float.valueOf(value));
    }

    @Override
    public void setDouble(K key, double value) {
        this.set(key, value);
    }

    @Override
    public void setBoolean(K key, boolean value) {
        this.set(key, value);
    }

    @Override
    public void setChar(K key, char value) {
        this.set(key, Character.valueOf(value));
    }
}

