/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.ui.image;

import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.io.IOs;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class BigBufferedImage
extends BufferedImage {
    public static final int MAX_PIXELS_IN_MEMORY = 0x100000;

    public static BufferedImage create(int width, int height, int imageType) {
        if (width * height > 0x100000) {
            try {
                File tempDir = new File(SystemPropertys.getJavaIOTmpDir());
                return BigBufferedImage.createBigBufferedImage(tempDir, width, height, imageType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new BufferedImage(width, height, imageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage create(File inputFile, int imageType) throws IOException {
        block7: {
            ImageInputStream stream = null;
            try {
                stream = ImageIO.createImageInputStream(inputFile);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                if (!readers.hasNext()) break block7;
                try {
                    ImageReader reader = readers.next();
                    reader.setInput(stream, true, true);
                    int width = reader.getWidth(reader.getMinIndex());
                    int height = reader.getHeight(reader.getMinIndex());
                    BufferedImage image = BigBufferedImage.create(width, height, imageType);
                    int cores = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
                    int block = Math.min(0x100000 / cores / width, (int)Math.ceil((double)height / (double)cores));
                    ExecutorService generalExecutor = Executors.newFixedThreadPool(cores);
                    ArrayList<ImagePartLoader> partLoaders = new ArrayList<ImagePartLoader>();
                    for (int y = 0; y < height; y += block) {
                        partLoaders.add(new ImagePartLoader(y, width, Math.min(block, height - y), inputFile, image));
                    }
                    generalExecutor.invokeAll(partLoaders);
                    generalExecutor.shutdown();
                    BufferedImage bufferedImage = image;
                    return bufferedImage;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BigBufferedImage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            finally {
                IOs.close(stream);
            }
        }
        return null;
    }

    private static BufferedImage createBigBufferedImage(File tempDir, int width, int height, int imageType) throws FileNotFoundException, IOException {
        FileDataBuffer buffer = new FileDataBuffer(tempDir, width * height, 4);
        ComponentColorModel colorModel = null;
        BandedSampleModel sampleModel = null;
        switch (imageType) {
            case 1: {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 3, 0);
                sampleModel = new BandedSampleModel(0, width, height, 3);
                break;
            }
            case 2: {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
                sampleModel = new BandedSampleModel(0, width, height, 4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type: " + imageType);
            }
        }
        SimpleRaster raster = new SimpleRaster((SampleModel)sampleModel, buffer, new Point(0, 0));
        return new BigBufferedImage((ColorModel)colorModel, raster, colorModel.isAlphaPremultiplied(), null);
    }

    private BigBufferedImage(ColorModel cm, SimpleRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        super(cm, raster, isRasterPremultiplied, properties);
    }

    public void dispose() {
        ((SimpleRaster)this.getRaster()).dispose();
    }

    public static void dispose(RenderedImage image) {
        if (image instanceof BigBufferedImage) {
            ((BigBufferedImage)image).dispose();
        }
    }

    private static class FileDataBuffer
    extends DataBuffer {
        private final String id = "buffer-" + System.currentTimeMillis() + "-" + GlobalThreadLocalMap.getRandom().nextInt(1000);
        private File dir;
        private String path;
        private File[] files;
        private RandomAccessFile[] accessFiles;
        private MappedByteBuffer[] buffer;

        public FileDataBuffer(File dir, int size) throws FileNotFoundException, IOException {
            super(0, size);
            this.dir = dir;
            this.init();
        }

        public FileDataBuffer(File dir, int size, int numBanks) throws FileNotFoundException, IOException {
            super(0, size, numBanks);
            this.dir = dir;
            this.init();
        }

        private void init() throws FileNotFoundException, IOException {
            FileDataBufferDeleterHook.undisposedBuffers.add(this);
            if (this.dir == null) {
                this.dir = new File(".");
            }
            if (!this.dir.exists()) {
                throw new RuntimeException("FileDataBuffer constructor parameter dir does not exist: " + this.dir);
            }
            if (!this.dir.isDirectory()) {
                throw new RuntimeException("FileDataBuffer constructor parameter dir is not a directory: " + this.dir);
            }
            this.path = this.dir.getPath() + "/" + this.id;
            File subDir = new File(this.path);
            subDir.mkdir();
            this.buffer = new MappedByteBuffer[this.banks];
            this.accessFiles = new RandomAccessFile[this.banks];
            this.files = new File[this.banks];
            for (int i = 0; i < this.banks; ++i) {
                File file = this.files[i] = new File(this.path + "/bank" + i + ".dat");
                RandomAccessFile randomAccessFile = this.accessFiles[i] = new RandomAccessFile(file, "rw");
                this.buffer[i] = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.getSize());
            }
        }

        @Override
        public int getElem(int bank, int i) {
            return this.buffer[bank].get(i) & 0xFF;
        }

        @Override
        public void setElem(int bank, int i, int val) {
            this.buffer[bank].put(i, (byte)val);
        }

        protected void finalize() throws Throwable {
            this.dispose();
        }

        public void dispose() {
            new Thread(){

                @Override
                public void run() {
                    FileDataBuffer.this.disposeNow();
                }
            }.start();
        }

        private void disposeNow() {
            this.buffer = null;
            if (this.accessFiles != null) {
                for (RandomAccessFile randomAccessFile : this.accessFiles) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.accessFiles = null;
            }
            if (this.files != null) {
                for (File file : this.files) {
                    file.delete();
                }
                this.files = null;
            }
            if (this.path != null) {
                new File(this.path).delete();
                this.path = null;
            }
        }
    }

    private static final class FileDataBufferDeleterHook
    extends Thread {
        private static final HashSet<FileDataBuffer> undisposedBuffers;

        private FileDataBufferDeleterHook() {
        }

        @Override
        public void run() {
            FileDataBuffer[] buffers;
            for (FileDataBuffer b : buffers = undisposedBuffers.toArray(new FileDataBuffer[0])) {
                b.disposeNow();
            }
        }

        static {
            Runtime.getRuntime().addShutdownHook(new FileDataBufferDeleterHook());
            undisposedBuffers = new HashSet();
        }
    }

    private static class SimpleRaster
    extends WritableRaster {
        public SimpleRaster(SampleModel sampleModel, FileDataBuffer dataBuffer, Point origin) {
            super(sampleModel, dataBuffer, origin);
        }

        public void dispose() {
            ((FileDataBuffer)this.getDataBuffer()).dispose();
        }
    }

    private static class ImagePartLoader
    implements Callable<ImagePartLoader> {
        private final int y;
        private final BufferedImage image;
        private final Rectangle region;
        private final File file;

        public ImagePartLoader(int y, int width, int height, File file, BufferedImage image) {
            this.y = y;
            this.image = image;
            this.file = file;
            this.region = new Rectangle(0, y, width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ImagePartLoader call() throws Exception {
            Thread.currentThread().setPriority(3);
            ImageInputStream stream = null;
            try {
                stream = ImageIO.createImageInputStream(this.file);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                if (readers.hasNext()) {
                    ImageReader reader = readers.next();
                    reader.setInput(stream, true, true);
                    ImageReadParam param = reader.getDefaultReadParam();
                    param.setSourceRegion(this.region);
                    BufferedImage part = reader.read(0, param);
                    WritableRaster source = part.getRaster();
                    WritableRaster target = this.image.getRaster();
                    target.setRect(0, this.y, source);
                }
            }
            finally {
                IOs.close(stream);
            }
            return this;
        }
    }
}

