/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml.resolver;

import com.jn.langx.util.io.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDEntityResolver
implements EntityResolver {
    private InputStream dtdInputStream;

    public DTDEntityResolver(InputStream dtdInputStream) {
        this.dtdInputStream = dtdInputStream;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = null;
        try {
            File file = null;
            if (systemId != null && !systemId.isEmpty()) {
                file = new File(systemId);
            } else if (publicId != null && !publicId.isEmpty()) {
                file = new File(publicId);
            }
            if (file != null && file.exists()) {
                source = new InputSource(new FileInputStream(file));
            }
            if (source == null) {
                if (this.dtdInputStream != null) {
                    return new InputSource(this.dtdInputStream);
                }
                source = new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(Charsets.UTF_8)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }
}

