/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.text.xml.XmlDocumentHandler;
import com.jn.langx.text.xml.errorhandler.RaiseErrorHandler;
import com.jn.langx.text.xml.resolver.DTDEntityResolver;
import com.jn.langx.text.xml.resolver.NullEntityResolver;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class Xmls {
    private static final String NULL_XML_STR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public static Document getXmlDoc(InputStream xml) throws Exception {
        return Xmls.getXmlDoc(null, xml);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, InputStream xml) throws Exception {
        return Xmls.getXmlDoc(entityResolver, null, xml);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml) throws Exception {
        return Xmls.getXmlDoc(entityResolver, errorHandler, xml, true);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml, boolean namespaceAware) throws Exception {
        return Xmls.getXmlDoc(entityResolver, errorHandler, xml, false, false, namespaceAware);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml, boolean ignoreComments, boolean ignoringElementContentWhitespace, boolean namespaceAware) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(ignoreComments);
        factory.setIgnoringElementContentWhitespace(ignoringElementContentWhitespace);
        factory.setNamespaceAware(namespaceAware);
        if (entityResolver != null) {
            factory.setValidating(true);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        entityResolver = entityResolver == null ? new NullEntityResolver() : entityResolver;
        builder.setEntityResolver(entityResolver);
        builder.setErrorHandler(errorHandler == null ? new RaiseErrorHandler() : errorHandler);
        return builder.parse(xml);
    }

    public static Document getXmlDoc(InputStream dtdInputStream, String src, boolean srcIsPath) throws Exception {
        if (srcIsPath) {
            return Xmls.getXmlDoc(dtdInputStream, src);
        }
        return Xmls.getXmlDoc(new DTDEntityResolver(dtdInputStream), new ByteArrayInputStream(src.getBytes(Charsets.UTF_8)));
    }

    public static Document getXmlDoc(InputStream dtdInputStream, String xmlfilepathOrURI) throws Exception {
        File file = new File(xmlfilepathOrURI);
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + xmlfilepathOrURI + "' does not exist .");
        }
        return Xmls.getXmlDoc(new DTDEntityResolver(dtdInputStream), new FileInputStream(file));
    }

    public static void writeDocToOutputStream(Document doc, OutputStream out) throws Exception {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(out));
    }

    public static void writeDocToFile(Document doc, File file) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(file));
    }

    public static <T> T handleXml(String xmlpath, XmlDocumentHandler<T> handler) {
        T t;
        FileInputStream input = null;
        Document doc = null;
        try {
            File file = new File(xmlpath);
            if (!file.exists()) {
                throw new FileNotFoundException("File '" + xmlpath + "' does not exist .");
            }
            input = new FileInputStream(file);
            doc = Xmls.getXmlDoc(null, input);
            t = handler.handle(doc);
        }
        catch (Exception ex) {
            try {
                throw Throwables.wrapAsRuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOs.close(input);
                throw throwable;
            }
        }
        IOs.close(input);
        return t;
    }
}

