/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.text.xml.NodeNamespaceContext;
import com.jn.langx.text.xml.XmlDocumentHandler;
import com.jn.langx.text.xml.Xmls;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlAccessor {
    private static final Logger logger = LoggerFactory.getLogger(XmlAccessor.class);
    private String defaultNamespacePrefix = null;

    public XmlAccessor() {
    }

    public XmlAccessor(String defaultNamespacePrefix) {
        this.setDefaultNamespacePrefix(defaultNamespacePrefix);
    }

    public String getDefaultNamespacePrefix() {
        return this.defaultNamespacePrefix;
    }

    public void setDefaultNamespacePrefix(String defaultNamespacePrefix) {
        this.defaultNamespacePrefix = defaultNamespacePrefix;
    }

    public void setElementAttribute(Document doc, XPathFactory factory, String elementXpath, String attributeName, String attributeValue) throws Exception {
        if (Emptys.isEmpty(attributeName)) {
            return;
        }
        try {
            Element element = this.getElement(doc, factory, elementXpath);
            if (Emptys.isEmpty(element)) {
                return;
            }
            element.setAttribute(attributeName, attributeValue);
            if (logger.isDebugEnabled()) {
                logger.debug("set attribute {} = {} for element {}", new Object[]{attributeName, attributeValue, elementXpath});
            }
        }
        catch (Exception ex) {
            logger.error("Error occur when set attribute {} for element {}", (Object)attributeName, (Object)elementXpath);
            throw ex;
        }
    }

    public void setElementAttributes(Document doc, XPathFactory factory, final String elementXpath, Map<String, String> attrs) throws Exception {
        if (Emptys.isEmpty(attrs)) {
            return;
        }
        try {
            final Element element = this.getElement(doc, factory, elementXpath);
            if (Emptys.isEmpty(element)) {
                return;
            }
            Collects.forEach(attrs, new Consumer2<String, String>(){

                @Override
                public void accept(String attributeName, String value) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("set attribute {} = {} for element {}", new Object[]{attributeName, value, elementXpath});
                    }
                    element.setAttribute(attributeName, value);
                }
            });
        }
        catch (Exception ex) {
            logger.error("Error occur when set attribute for element {}", (Object)elementXpath);
            throw ex;
        }
    }

    public void setElementsAttributes(Document doc, XPathFactory factory, final String elementXpath, final Map<String, String> attrs) throws Exception {
        if (Emptys.isEmpty(attrs)) {
            return;
        }
        try {
            NodeList elements = this.getNodeList(doc, factory, elementXpath);
            if (Emptys.isEmpty(elements)) {
                return;
            }
            Collects.forEach(Collects.asIterable(elements), new Consumer<Element>(){

                @Override
                public void accept(final Element element) {
                    Collects.forEach(attrs, new Consumer2<String, String>(){

                        @Override
                        public void accept(String attributeName, String value) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("set attribute {} = {} for element {}", new Object[]{attributeName, attrs.get(attributeName), elementXpath});
                            }
                            element.setAttribute(attributeName, (String)attrs.get(attributeName));
                        }
                    });
                }
            });
        }
        catch (Exception ex) {
            logger.error("Error occur when set attribute for element {}", (Object)elementXpath);
            throw ex;
        }
    }

    public String getElementAttribute(String xmlFilePath, final String elementXpath, final String attributeName) throws Exception {
        return Xmls.handleXml(xmlFilePath, new XmlDocumentHandler<String>(){

            @Override
            public String handle(Document doc) throws Exception {
                XPathFactory factory = XPathFactory.newInstance();
                return XmlAccessor.this.getElementAttribute(doc, factory, elementXpath, attributeName);
            }
        });
    }

    public String getElementAttribute(Document doc, XPathFactory factory, String elementXpath, String attributeName) throws Exception {
        try {
            String ret;
            if (Emptys.isEmpty(attributeName)) {
                throw new IllegalArgumentException("attributeName is empty .");
            }
            Element element = this.getElement(doc, factory, elementXpath);
            Attr attr = element.getAttributeNode(attributeName);
            String string = ret = Emptys.isEmpty(attr) ? "" : attr.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug("get attribute {} from {} is {}", new Object[]{attributeName, elementXpath, ret});
            }
            return ret;
        }
        catch (Exception ex) {
            logger.error("Error occur when get attribute {} from element {}", (Object)attributeName, (Object)elementXpath);
            throw ex;
        }
    }

    public Node getNode(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(doc, this.defaultNamespacePrefix));
        XPathExpression exp = xpath.compile(elementXpath);
        return (Node)exp.evaluate(doc, XPathConstants.NODE);
    }

    public Element getElement(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        return (Element)this.getNode(doc, factory, elementXpath);
    }

    public Attr getAttr(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        return (Attr)this.getNode(doc, factory, elementXpath);
    }

    public NodeList getNodeList(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(doc, this.defaultNamespacePrefix));
        XPathExpression exp = xpath.compile(elementXpath);
        return (NodeList)exp.evaluate(doc, XPathConstants.NODESET);
    }

    public String getString(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(doc, this.defaultNamespacePrefix));
        XPathExpression exp = xpath.compile(elementXpath);
        return (String)exp.evaluate(doc, XPathConstants.STRING);
    }

    public Number getNumber(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(doc, this.defaultNamespacePrefix));
        XPathExpression exp = xpath.compile(elementXpath);
        return (Number)exp.evaluate(doc, XPathConstants.NUMBER);
    }

    public Boolean getBoolean(Document doc, XPathFactory factory, String elementXpath) throws XPathExpressionException {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(doc, this.defaultNamespacePrefix));
        XPathExpression exp = xpath.compile(elementXpath);
        return (Boolean)exp.evaluate(doc, XPathConstants.BOOLEAN);
    }
}

