/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.stringtemplate;

import com.jn.langx.text.stringtemplate.BeanBasedStyleStringFormatter;
import com.jn.langx.text.stringtemplate.CustomPatternStringFormatter;
import com.jn.langx.text.stringtemplate.IndexStringFormatter;
import com.jn.langx.text.stringtemplate.MapBasedStringFormatter;
import com.jn.langx.text.stringtemplate.PlaceholderStringFormatter;
import com.jn.langx.text.stringtemplate.StringTemplateFormatter;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.struct.Entry;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Pair;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class StringTemplateFormatterChain
implements StringTemplateFormatter {
    private List<Pair<StringTemplateFormatter, Object[]>> chain = Collects.emptyArrayList();

    public StringTemplateFormatterChain addFormatterAndParameters(StringTemplateFormatter formatter, Object ... args) {
        if (Objects.nonNull(formatter)) {
            this.chain.add(new Entry<StringTemplateFormatter, Object[]>(formatter, args));
        }
        return this;
    }

    public StringTemplateFormatterChain addFormatterAndParameters(Pattern pattern, Function2<String, Object[], String> valueGetter, Object ... args) {
        return this.addFormatterAndParameters(new CustomPatternStringFormatter(pattern, valueGetter), args);
    }

    public StringTemplateFormatterChain addFormatterAndParameters(String variablePattern, Function2<String, Object[], String> valueGetter, Object ... args) {
        return this.addFormatterAndParameters(Pattern.compile(variablePattern), valueGetter, args);
    }

    public StringTemplateFormatterChain addIndexedFormatterAndParameters(Object ... args) {
        return this.addFormatterAndParameters(new IndexStringFormatter(), args);
    }

    public StringTemplateFormatterChain addPlaceHolderFormatterAndParameters(Object ... args) {
        return this.addFormatterAndParameters(new PlaceholderStringFormatter(), args);
    }

    public <T> StringTemplateFormatterChain addBeanBasedFormatterAndParameters(T bean) {
        return this.addFormatterAndParameters(new BeanBasedStyleStringFormatter(), bean);
    }

    public StringTemplateFormatterChain addMapBasedFormatterAndParameters(Map<String, Object> map) {
        return this.addFormatterAndParameters(new MapBasedStringFormatter(), map);
    }

    @Override
    public String format(String template, Object ... args) {
        Preconditions.checkNotNull(template);
        final Holder<String> templateHolder = new Holder<String>(template);
        Collects.forEach(this.chain, new Consumer<Pair<StringTemplateFormatter, Object[]>>(){

            @Override
            public void accept(Pair<StringTemplateFormatter, Object[]> pair) {
                templateHolder.set(pair.getKey().format((String)templateHolder.get(), pair.getValue()));
            }
        });
        return templateHolder.get();
    }
}

