/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.stringtemplate;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.ThrowableFunction;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.function.Function2;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTemplate {
    private static final Logger logger = LoggerFactory.getLogger(StringTemplate.class);
    public static final Pattern defaultPattern = Pattern.compile("\\{\\d+}");
    private static final Function2<String, Object[], String> defaultValueGetter = new IndexBasedValueGetter();
    private Pattern variablePattern = defaultPattern;
    private String template;
    private Function2<String, Object[], String> valueGetter = defaultValueGetter;

    public StringTemplate variablePattern(String pattern) {
        if (Emptys.isNotEmpty(pattern)) {
            return this.variablePattern(Pattern.compile(pattern));
        }
        return this;
    }

    public StringTemplate variablePattern(Pattern pattern) {
        if (Emptys.isNotNull(pattern)) {
            this.variablePattern = pattern;
        }
        return this;
    }

    public StringTemplate using(String template) {
        Preconditions.checkNotNull(template);
        this.template = template;
        return this;
    }

    public StringTemplate with(Function2<String, Object[], String> valueGetter) {
        if (valueGetter != null) {
            this.valueGetter = valueGetter;
        }
        if (this.variablePattern == defaultPattern) {
            this.valueGetter = defaultValueGetter;
        }
        return this;
    }

    public String format(Object[] args) {
        if (Emptys.isNull(args)) {
            args = new Object[]{};
        }
        Matcher matcher = this.variablePattern.matcher(this.template);
        StringBuffer b = new StringBuffer();
        while (matcher.find()) {
            final String matched = matcher.group();
            String value = Throwables.ignoreThrowable(logger, matched, new ThrowableFunction<Object[], String>(){

                @Override
                public String doFun(Object[] args) throws Throwable {
                    return (String)StringTemplate.this.valueGetter.apply(matched, args);
                }
            }, args);
            value = Objects.isNull(value) ? matched : value;
            matcher.appendReplacement(b, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(b);
        return b.toString();
    }

    public static class IndexBasedValueGetter
    implements Function2<String, Object[], String> {
        @Override
        public String apply(String matched, Object[] args) {
            Object object = args[this.getIndex(matched)];
            return Emptys.isNull(object) ? "" : object.toString();
        }

        private int getIndex(String matched) {
            int index;
            String indexString = matched;
            if (matched.startsWith("{") && matched.endsWith("}")) {
                indexString = matched.substring(1, matched.length() - 1);
            }
            if ((index = Integer.parseInt(indexString)) < 0) {
                index = 0;
            }
            return index;
        }
    }
}

