/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.i18n;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.i18n.HierarchicalI18nMessageStorage;
import com.jn.langx.text.i18n.I18nMessageStorage;
import com.jn.langx.text.i18n.LanguageCode;
import com.jn.langx.text.i18n.LocaleCode;
import com.jn.langx.util.ClassLoaders;
import java.util.Locale;

public abstract class AbstractI18nMessageStorage
implements HierarchicalI18nMessageStorage {
    private Locale locale = Locale.getDefault();
    private I18nMessageStorage parent;

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    @Override
    public void setParent(I18nMessageStorage parent) {
        this.parent = parent;
    }

    @Override
    public I18nMessageStorage getParent() {
        return this.parent;
    }

    @Override
    public String getMessage(@NonNull String key, @Nullable Object[] args) {
        return this.getMessage(this.getClassLoader(null), key, args);
    }

    @Override
    public String getMessage(@Nullable ClassLoader classLoader, @NonNull String key, Object ... args) {
        return this.getMessage(this.getLocale(), this.getClassLoader(classLoader), key, args);
    }

    @Override
    public String getMessage(@Nullable LanguageCode languageCode, @NonNull String key, Object ... args) {
        return this.getMessage(languageCode, this.getClassLoader(null), key, args);
    }

    @Override
    public String getMessage(@Nullable LanguageCode languageCode, @Nullable ClassLoader classLoader, @NonNull String key, Object ... args) {
        return this.getMessage(this.toLocale((Object)languageCode), this.getClassLoader(classLoader), key, args);
    }

    @Override
    public String getMessage(@Nullable LocaleCode localeCode, @NonNull String key, Object ... args) {
        return this.getMessage(localeCode, this.getClassLoader(null), key, args);
    }

    @Override
    public String getMessage(@Nullable LocaleCode localeCode, @Nullable ClassLoader classLoader, @NonNull String key, Object ... args) {
        return this.getMessage(this.toLocale((Object)localeCode), this.getClassLoader(classLoader), key, args);
    }

    @Override
    public String getMessage(@Nullable Locale locale, @NonNull String key, Object ... args) {
        return this.getMessageInternal(locale, this.getClassLoader(null), key, args);
    }

    @Override
    public String getMessage(@Nullable Locale locale, @Nullable ClassLoader classLoader, @NonNull String key, Object ... args) {
        return this.getMessageInternal(locale, this.getClassLoader(classLoader), key, args);
    }

    protected abstract String getMessageInternal(@NonNull Locale var1, @NonNull ClassLoader var2, @NonNull String var3, Object ... var4);

    protected Locale toLocale(Object locale) {
        if (locale == null) {
            return this.getLocale();
        }
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof LocaleCode) {
            return ((LocaleCode)((Object)locale)).toLocale();
        }
        if (locale instanceof LanguageCode) {
            return ((LanguageCode)((Object)locale)).toLocale();
        }
        return this.getLocale();
    }

    protected ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassLoaders.getDefaultClassLoader();
        }
        return classLoader;
    }
}

