/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl;

import com.jn.langx.security.ssl.NoopTrustManager;
import com.jn.langx.security.ssl.SSLContextBuilder;
import com.jn.langx.security.ssl.SSLInitializationException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class SSLs {
    private SSLs() {
    }

    public static X509TrustManager noopX509TrustManager() {
        return new NoopTrustManager();
    }

    public static SSLContext defaultSSLContext() throws SSLInitializationException {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
        catch (KeyManagementException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    public static SSLContext systemDefaultSSLContext() throws SSLInitializationException {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException ex) {
            return SSLs.defaultSSLContext();
        }
    }

    public static SSLContextBuilder customSSLContext() {
        return SSLContextBuilder.create();
    }
}

