/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.ssl;

import com.jn.langx.security.ssl.PrivateKeyAliasChooseStrategy;
import com.jn.langx.security.ssl.PrivateKeyDetails;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

class InternalKeyManagerProxy
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager keyManager;
    private final PrivateKeyAliasChooseStrategy aliasStrategy;

    InternalKeyManagerProxy(X509ExtendedKeyManager keyManager, PrivateKeyAliasChooseStrategy aliasStrategy) {
        this.keyManager = keyManager;
        this.aliasStrategy = aliasStrategy;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    public Map<String, PrivateKeyDetails> getClientAliasMap(String[] keyTypes, Principal[] issuers) {
        HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
        for (String keyType : keyTypes) {
            String[] aliases = this.keyManager.getClientAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
            }
        }
        return validAliases;
    }

    public Map<String, PrivateKeyDetails> getServerAliasMap(String keyType, Principal[] issuers) {
        HashMap<String, PrivateKeyDetails> validAliases = new HashMap<String, PrivateKeyDetails>();
        String[] aliases = this.keyManager.getServerAliases(keyType, issuers);
        if (aliases != null) {
            for (String alias : aliases) {
                validAliases.put(alias, new PrivateKeyDetails(keyType, this.keyManager.getCertificateChain(alias)));
            }
        }
        return validAliases;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        Map<String, PrivateKeyDetails> validAliases = this.getClientAliasMap(keyTypes, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, socket);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        Map<String, PrivateKeyDetails> validAliases = this.getServerAliasMap(keyType, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine sslEngine) {
        Map<String, PrivateKeyDetails> validAliases = this.getClientAliasMap(keyTypes, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, null);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine sslEngine) {
        Map<String, PrivateKeyDetails> validAliases = this.getServerAliasMap(keyType, issuers);
        return this.aliasStrategy.chooseAlias(validAliases, null);
    }
}

