/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.prevention.injection;

import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.struct.Holder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogInjectionPreventionHandler
implements Function<String, String> {
    private Map<Pattern, String> replacementMapping = new HashMap<Pattern, String>();

    public void addReplacement(Pattern pattern, String replacement) {
        this.replacementMapping.put(pattern, replacement);
    }

    public void addCLRFReplacement(String replacement) {
        replacement = Strings.isEmpty(replacement) ? "_" : replacement;
        String pattern = "[\r\n\f]";
        this.addReplacement(Pattern.compile(pattern), replacement);
    }

    @Override
    public String apply(String input) {
        if (input == null) {
            return null;
        }
        final Holder<String> stringHolder = new Holder<String>(input);
        Collects.forEach(this.replacementMapping, new Consumer2<Pattern, String>(){

            @Override
            public void accept(Pattern pattern, String replacement) {
                String v = (String)stringHolder.get();
                Matcher matcher = pattern.matcher(v);
                StringBuffer b = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(b, Matcher.quoteReplacement(replacement));
                }
                matcher.appendTail(b);
                v = b.toString();
                stringHolder.set(v);
            }
        }, new Predicate2<Pattern, String>(){

            @Override
            public boolean test(Pattern pattern, String str) {
                return stringHolder.isEmpty();
            }
        });
        return stringHolder.get();
    }
}

