/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.gm;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.lifecycle.AbstractInitializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.gm.GmService;
import com.jn.langx.util.Objs;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;

@Singleton
public class GMs
extends AbstractInitializable {
    private GenericRegistry<GmService> registry = new GenericRegistry(new LinkedHashMap());
    private static final GMs INSTANCE = new GMs();

    private GMs() {
        this.init();
    }

    public static GMs getGMs() {
        return INSTANCE;
    }

    public GmService getDefault() {
        List<GmService> serviceList = this.registry.instances();
        if (Objs.isNotEmpty(serviceList)) {
            return serviceList.get(0);
        }
        return null;
    }

    @Override
    protected void doInit() throws InitializationException {
        for (GmService gmService : ServiceLoader.load(GmService.class)) {
            this.registry.register(gmService);
        }
    }

    public GmService getGmService(String name) {
        return this.registry.get(name);
    }
}

