/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.provider;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.security.crypto.provider.ConfigurableSecurityProvider;
import com.jn.langx.security.crypto.provider.LangxSecurityProviderConfigurer;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.LinkedCaseInsensitiveMap;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.reflect.Reflects;
import java.security.Provider;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangxSecurityProvider
extends Provider
implements ConfigurableSecurityProvider {
    private static final Logger logger = LoggerFactory.getLogger(LangxSecurityProvider.class);
    public static final String NAME = "langx-java-security-provider";
    private Map<String, String> properties = new TreeMap<String, String>();
    private Map<String, String> propertiesBackup = new LinkedCaseInsensitiveMap<String>();

    public LangxSecurityProvider(String name, double version, String info) {
        super(name, version, info);
        this.setup();
    }

    public LangxSecurityProvider() {
        this(NAME, 1.0, "com.jn.langx");
    }

    @Override
    public boolean hasAlgorithm(String type, String name) {
        return this.containsKey(type + "." + name) || this.containsKey("Alg.Alias." + type + "." + name);
    }

    @Override
    public void addAlgorithm(String key, Class spiClass) {
        this.addAlgorithm(key, Reflects.getFQNClassName(spiClass));
    }

    @Override
    public void addAlgorithm(String key, String value) {
        if (this.containsKey(key)) {
            logger.warn("duplicate provider key {} found, its value: {}", (Object)key, this.get(key));
            return;
        }
        this.put(key, value);
        this.properties.put(key, value);
        this.propertiesBackup.put(key, value);
    }

    public void addAlgorithmOid(@NonNull String type, @NonNull String oid, @NonNull Class spiClassName) {
        this.addAlgorithmOid(type, oid, Reflects.getFQNClassName(spiClassName));
    }

    @Override
    public void addAlgorithmOid(@NonNull String type, @NonNull String oid, @NonNull String spiClassName) {
        Preconditions.checkNotEmpty(type, "type is null or empty");
        Preconditions.checkNotEmpty(oid, "oid is null or empty");
        Preconditions.checkNotEmpty(spiClassName, "the spi class name is null or empty for {}", type + "." + oid);
        this.addAlgorithm(type + "." + oid, spiClassName);
        this.addAlgorithm(type + ".OID." + oid, spiClassName);
    }

    @Override
    public void addAlias(String name, String alias) {
        this.addAlgorithm("Alg.Alias." + name, alias);
    }

    @Override
    public void addHmacAlgorithm(String digestAlgo, Class hmacAlgoSpiClass, Class keyGenSpiClass) {
        this.addHmacAlgorithm(digestAlgo, Reflects.getFQNClassName(hmacAlgoSpiClass), Reflects.getFQNClassName(keyGenSpiClass));
    }

    @Override
    public void addHmacAlgorithm(String digestAlgo, String hmacAlgoSpiClassName, String keyGenSpiClassName) {
        String hmacAlgorithm = "HMAC" + digestAlgo;
        this.addAlgorithm("Mac." + hmacAlgorithm, hmacAlgoSpiClassName);
        this.addAlias("Mac.HMAC-" + digestAlgo, hmacAlgorithm);
        this.addAlias("Mac.HMAC/" + digestAlgo, hmacAlgorithm);
        this.addAlgorithm("KeyGenerator." + hmacAlgorithm, keyGenSpiClassName);
        this.addAlias("KeyGenerator.HMAC-" + digestAlgo, hmacAlgorithm);
        this.addAlias("KeyGenerator.HMAC/" + digestAlgo, hmacAlgorithm);
    }

    @Override
    public void addHmacOidAlias(String hmacOid, String digestAlgorithm) {
        String hmacAlgorithm = "HMAC" + digestAlgorithm;
        this.addAlias("Mac." + hmacOid, hmacAlgorithm);
        this.addAlias("KeyGenerator." + hmacOid, hmacAlgorithm);
    }

    private void setup() {
        this.load();
    }

    private void load() {
        Collects.forEach(ServiceLoader.load(LangxSecurityProviderConfigurer.class), new Consumer<LangxSecurityProviderConfigurer>(){

            @Override
            public void accept(LangxSecurityProviderConfigurer configurer) {
                configurer.configure(LangxSecurityProvider.this);
            }
        });
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String findAlgorithm(String type, String algorithm) {
        String value = this.propertiesBackup.get(type + "." + algorithm);
        if (Strings.isNotEmpty(value)) {
            return value;
        }
        String alias = this.propertiesBackup.get("Alg.Alias." + type + "." + algorithm);
        if (Strings.isNotEmpty(alias)) {
            value = this.propertiesBackup.get(type + "." + alias);
        }
        return value;
    }
}

