/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.key.supplier.bytesbased;

import com.jn.langx.Parser;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.security.crypto.cipher.Asymmetrics;
import com.jn.langx.security.crypto.key.PKIs;
import com.jn.langx.security.crypto.key.spec.der.DsaPrivateKeySpecParser;
import com.jn.langx.security.crypto.key.spec.der.EcPrivateKeySpecParser;
import com.jn.langx.security.crypto.key.spec.der.Pkcs8PrivateKeySpecParser;
import com.jn.langx.security.crypto.key.spec.der.RsaPkcs1PrivateKeySpecParser;
import com.jn.langx.security.crypto.key.supplier.bytesbased.BytesBasedKeySupplier;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.multivalue.CommonMultiValueMap;
import com.jn.langx.util.collection.multivalue.MultiValueMap;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.struct.Holder;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.spec.KeySpec;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BytesBasedPrivateKeySupplier
implements BytesBasedKeySupplier<PrivateKey> {
    private static final Logger logger = LoggerFactory.getLogger(BytesBasedPrivateKeySupplier.class);
    private final MultiValueMap<String, Parser<byte[], ? extends KeySpec>> keySpecParsers = new CommonMultiValueMap<String, Parser<byte[], ? extends KeySpec>>();

    public BytesBasedPrivateKeySupplier() {
        this.addKeySpecParser("EC", new EcPrivateKeySpecParser());
        this.addKeySpecParser("DSA", new DsaPrivateKeySpecParser());
        this.addKeySpecParser("RSA", new RsaPkcs1PrivateKeySpecParser());
    }

    public void addKeySpecParser(String algorithm, Parser<byte[], ? extends KeySpec> parser) {
        this.keySpecParsers.add(algorithm, parser);
    }

    @Override
    public PrivateKey get(final @NonNull byte[] bytes, @NonNull String algorithm, @Nullable Provider provider) {
        String _algorithm = Asymmetrics.extractCipherAlgorithm(algorithm);
        Collection parsers = (Collection)this.keySpecParsers.get(_algorithm);
        final Holder keySpecHolder = new Holder();
        Pipeline.of(parsers).add(Pkcs8PrivateKeySpecParser.INSTANCE).forEach((Consumer<Pkcs8PrivateKeySpecParser>)new Consumer<Parser<byte[], ? extends KeySpec>>(){

            @Override
            public void accept(Parser<byte[], ? extends KeySpec> parser) {
                KeySpec keySpec = null;
                try {
                    keySpec = parser.parse(bytes);
                    if (keySpec != null) {
                        keySpecHolder.set(keySpec);
                    }
                }
                catch (Throwable ex) {
                    logger.debug(ex.getMessage(), ex);
                }
            }
        }, (Predicate<Pkcs8PrivateKeySpecParser>)new Predicate<Parser<byte[], ? extends KeySpec>>(){

            @Override
            public boolean test(Parser<byte[], ? extends KeySpec> value) {
                return !keySpecHolder.isNull();
            }
        });
        if (!keySpecHolder.isNull()) {
            PrivateKey privateKey = PKIs.createPrivateKey(_algorithm, provider == null ? null : provider.getName(), (KeySpec)keySpecHolder.get());
            return privateKey;
        }
        return null;
    }
}

