/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.digest;

import com.jn.langx.security.crypto.digest.BufferSizeAware;
import com.jn.langx.security.crypto.digest.internal.Digest;
import com.jn.langx.security.crypto.digest.internal.Xof;
import java.security.MessageDigest;

public class LangxMessageDigestSpi
extends MessageDigest
implements BufferSizeAware {
    protected Digest delegate;
    protected int digestSize;

    protected LangxMessageDigestSpi(Digest digest) {
        super(digest.getAlgorithmName());
        this.delegate = digest;
        this.digestSize = digest.getDigestSize();
    }

    protected LangxMessageDigestSpi(Xof digest, int outputSize) {
        super(digest.getAlgorithmName());
        this.delegate = digest;
        this.digestSize = outputSize / 8;
    }

    @Override
    public void engineReset() {
        this.delegate.reset();
    }

    @Override
    public void engineUpdate(byte input) {
        this.delegate.update(input);
    }

    @Override
    public void engineUpdate(byte[] input, int offset, int len) {
        this.delegate.update(input, offset, len);
    }

    @Override
    public int engineGetDigestLength() {
        return this.digestSize;
    }

    @Override
    public byte[] engineDigest() {
        byte[] digestBytes = new byte[this.digestSize];
        this.delegate.doFinal(digestBytes, 0);
        return digestBytes;
    }

    @Override
    public int getBufferSize() {
        return this.delegate.getBufferSize();
    }
}

