/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security.crypto.cipher;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.IllegalParameterException;
import com.jn.langx.security.SecurityException;
import com.jn.langx.security.Securitys;
import com.jn.langx.security.crypto.CryptoException;
import com.jn.langx.security.crypto.cipher.AlgorithmParameterSupplier;
import com.jn.langx.security.crypto.key.supplier.bytesbased.BytesBasedKeySupplier;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;

public class Ciphers
extends Securitys {
    protected static final Map<String, String> algorithmToTransformationMapping = new ConcurrentHashMap<String, String>();

    protected Ciphers() {
    }

    public static String getDefaultTransformation(String algorithm) {
        return algorithmToTransformationMapping.get(algorithm);
    }

    public static void addDefaultTransformation(String algorithm, String transformation) {
        algorithmToTransformationMapping.put(algorithm, transformation);
    }

    public static Cipher createEmptyCipher(@NonNull String algorithmTransformation, @Nullable Provider provider) {
        try {
            Cipher cipher = provider == null ? Cipher.getInstance(algorithmTransformation) : Cipher.getInstance(algorithmTransformation, provider);
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Key key, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                cipher.init(operateMode, key);
            } else {
                cipher.init(operateMode, key, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Key key, @Nullable AlgorithmParameterSpec parameterSpec, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                cipher.init(operateMode, key, parameterSpec);
            } else {
                cipher.init(operateMode, key, parameterSpec, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Key key, @Nullable AlgorithmParameters parameters, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                if (parameters != null) {
                    cipher.init(operateMode, key, parameters);
                } else {
                    cipher.init(operateMode, key);
                }
            } else if (parameters != null) {
                cipher.init(operateMode, key, parameters, secureRandom);
            } else {
                cipher.init(operateMode, key, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static Cipher createCipher(@NonNull String algorithmTransformation, @Nullable Provider provider, int operateMode, Certificate certificate, SecureRandom secureRandom) {
        try {
            Cipher cipher = Ciphers.createEmptyCipher(algorithmTransformation, provider);
            if (secureRandom == null) {
                cipher.init(operateMode, certificate);
            } else {
                cipher.init(operateMode, certificate, secureRandom);
            }
            return cipher;
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage(), ex);
        }
    }

    public static byte[] encrypt(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (Throwable ex) {
            throw new CryptoException(ex.getMessage(), ex);
        }
    }

    public static byte[] decrypt(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (Throwable ex) {
            throw new CryptoException(ex.getMessage(), ex);
        }
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, true);
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSpec parameterSpec) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSpec, true);
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, final @Nullable AlgorithmParameters parameters) {
        return Ciphers.encrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, new AlgorithmParameterSupplier(){

            @Override
            public Object get(Key key, String algorithm, String transform, Provider provider, SecureRandom secureRandom) {
                return parameters;
            }
        });
    }

    public static byte[] encrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSupplier parameterSupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSupplier, true);
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, false);
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSpec parameterSpec) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSpec, false);
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, final @Nullable AlgorithmParameters parameters) {
        return Ciphers.decrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, new AlgorithmParameterSupplier(){

            @Override
            public Object get(Key key, String algorithm, String transform, Provider provider, SecureRandom secureRandom) {
                return parameters;
            }
        });
    }

    public static byte[] decrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSupplier parameterSupplier) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, parameterSupplier, false);
    }

    public static byte[] doEncryptOrDecrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, boolean encrypt) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, (AlgorithmParameterSpec)null, encrypt);
    }

    public static byte[] doEncryptOrDecrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, final @Nullable AlgorithmParameterSpec parameterSpec, boolean encrypt) {
        return Ciphers.doEncryptOrDecrypt(bytes, keyBytes, algorithm, algorithmTransformation, provider, secureRandom, keySupplier, new AlgorithmParameterSupplier(){

            @Override
            public Object get(Key key, String algorithm, String transform, Provider provider, SecureRandom secureRandom) {
                return parameterSpec;
            }
        }, encrypt);
    }

    public static byte[] doEncryptOrDecrypt(byte[] bytes, byte[] keyBytes, String algorithm, String algorithmTransformation, Provider provider, SecureRandom secureRandom, @NonNull BytesBasedKeySupplier keySupplier, @Nullable AlgorithmParameterSupplier parameterSupplier, boolean encrypt) {
        Preconditions.checkNotEmpty(keyBytes, "{} key is empty", algorithm);
        Preconditions.checkArgument(!Emptys.isAllEmpty(algorithm, algorithmTransformation), "the algorithm and algorithmTransformation is empty");
        Preconditions.checkNotNull(keySupplier, "the key supplier is null");
        if (Emptys.isEmpty(algorithm)) {
            algorithm = Ciphers.extractAlgorithm(algorithmTransformation);
        }
        if (Emptys.isEmpty(algorithmTransformation) && Emptys.isEmpty(algorithmTransformation = Ciphers.getDefaultTransformation(algorithm))) {
            algorithmTransformation = Ciphers.createAlgorithmTransformation(algorithm, "ECB", "PKCS5Padding");
        }
        Object key = keySupplier.get(keyBytes, algorithm, provider);
        AlgorithmParameterSpec parameterSpec = null;
        AlgorithmParameters parameters = null;
        Object parameter = null;
        if (parameterSupplier != null && (parameter = parameterSupplier.get((Key)key, algorithm, algorithmTransformation, provider, secureRandom)) != null) {
            if (parameter instanceof AlgorithmParameterSpec) {
                parameterSpec = (AlgorithmParameterSpec)parameter;
            } else if (parameter instanceof AlgorithmParameters) {
                parameters = (AlgorithmParameters)parameter;
            } else if (parameter instanceof AlgorithmParameterGenerator) {
                AlgorithmParameterGenerator parameterGenerator = (AlgorithmParameterGenerator)parameter;
                parameters = parameterGenerator.generateParameters();
            }
        }
        if (parameterSpec == null && parameters == null && provider != null) {
            try {
                parameters = AlgorithmParameters.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException parameterGenerator) {
                // empty catch block
            }
        }
        try {
            Cipher cipher = null;
            cipher = parameters != null ? Ciphers.createCipher(algorithmTransformation, provider, encrypt ? 1 : 2, key, parameters, secureRandom) : Ciphers.createCipher(algorithmTransformation, provider, encrypt ? 1 : 2, key, parameterSpec, secureRandom);
            if (encrypt) {
                return Ciphers.encrypt(cipher, bytes);
            }
            return Ciphers.decrypt(cipher, bytes);
        }
        catch (Throwable ex) {
            throw new CryptoException(ex.getMessage(), ex);
        }
    }

    public static String createAlgorithmTransformation(String transformation) {
        Preconditions.checkNotEmpty(transformation, "the cipher algorithm transformation is null or empty");
        String[] components = Strings.split(transformation, "/");
        if (components.length == 0) {
            throw new IllegalParameterException(StringTemplates.formatWithPlaceholder("the cipher algorithm transformation is illegal: {}", transformation));
        }
        if (components.length < 3) {
            return components[0];
        }
        return Ciphers.createAlgorithmTransformation(components[0], components[1], components[2]);
    }

    public static String createAlgorithmTransformation(@NotEmpty String algorithm, @NotEmpty String mode, @NotEmpty String padding) {
        Preconditions.checkNotEmpty(algorithm, "the algorithm is null or empty");
        Preconditions.checkNotEmpty(mode, "the mode is null or empty");
        Preconditions.checkNotEmpty(padding, "the padding is null or empty");
        return StringTemplates.formatWithPlaceholder("{}/{}/{}", algorithm, mode, padding);
    }

    public static String extractAlgorithm(String transformation) {
        Preconditions.checkNotEmpty(transformation, "the cipher algorithm transformation is null or empty");
        String[] segments = Strings.split(transformation, "/");
        Preconditions.checkNotEmpty(segments, "invalid transformation: {}", transformation);
        return segments[0];
    }

    public static String extractCipherAlgorithm(String algorithm) {
        int indexOfWith;
        Preconditions.checkNotNull(algorithm, "algorithm must be not null !");
        if ((algorithm.contains("SM2") || algorithm.contains("EC")) && (indexOfWith = Strings.lastIndexOfIgnoreCase(algorithm, "with")) > 0) {
            algorithm = Strings.substring(algorithm, indexOfWith + "with".length());
        }
        if (Strings.contains(algorithm, "with", true)) {
            indexOfWith = Strings.lastIndexOfIgnoreCase(algorithm, "with");
            algorithm = Strings.substring(algorithm, indexOfWith + "with".length());
        } else if ("ECDSA".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        if (Strings.startsWith(algorithm, "EC", true)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    static {
        algorithmToTransformationMapping.put("AES", "AES/ECB/PKCS5Padding");
        algorithmToTransformationMapping.put("SM2", "SM2");
        algorithmToTransformationMapping.put("SM4", "SM4/CBC/PKCS7Padding");
        algorithmToTransformationMapping.put("RSA", "RSA/ECB/PKCS1Padding");
    }
}

