/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.security;

import com.jn.langx.security.crypto.provider.LangxSecurityProvider;
import com.jn.langx.security.gm.GmInitializer;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.struct.Holder;
import java.net.URLClassLoader;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Securitys {
    private static volatile boolean providersLoaded = false;
    private static LangxSecurityProvider langxSecurityProvider;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setup() {
        if (providersLoaded) return;
        Class<Securitys> clazz = Securitys.class;
        synchronized (Securitys.class) {
            Securitys.loadProviders();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Provider getProvider(String name) {
        if (Strings.isNotBlank(name)) {
            return null;
        }
        return Security.getProvider(name);
    }

    public static void addProvider(Provider provider) {
        Security.addProvider(provider);
    }

    public static void insertProvider(Provider provider) {
        Securitys.insertProviderAt(provider, 1);
    }

    public static void insertProviderAt(Provider provider, int position) {
        Security.insertProviderAt(provider, position);
    }

    public static void loadLangxProvider() {
        LangxSecurityProvider langxSecurityProvider = new LangxSecurityProvider();
        Provider[] providers = Security.getProviders();
        ClassLoader appClassLoader = ClassLoader.getSystemClassLoader();
        if (appClassLoader.getParent() instanceof URLClassLoader) {
            final URLClassLoader extClassLoader = (URLClassLoader)appClassLoader.getParent();
            final Holder firstProviderInExtClassLoader = new Holder();
            Provider expectedProvider = Collects.findFirst(Collects.asList(providers), new Predicate<Provider>(){

                @Override
                public boolean test(Provider provider) {
                    ClassLoader providerCL = provider.getClass().getClassLoader();
                    if (providerCL != null && providerCL != extClassLoader) {
                        return true;
                    }
                    if (providerCL == extClassLoader && firstProviderInExtClassLoader.isNull()) {
                        firstProviderInExtClassLoader.set(provider);
                    }
                    return false;
                }
            });
            if (expectedProvider != null) {
                Map<String, String> properties = langxSecurityProvider.getProperties();
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    expectedProvider.put(entry.getKey(), entry.getValue());
                }
            }
        }
        Securitys.insertProvider(langxSecurityProvider);
        Securitys.langxSecurityProvider = langxSecurityProvider;
    }

    public static boolean langxProviderInstalled() {
        return Security.getProvider("langx-java-security-provider") != null;
    }

    public static LangxSecurityProvider getLangxSecurityProvider() {
        return langxSecurityProvider;
    }

    private static void loadGMSupports() {
        for (GmInitializer initializer : ServiceLoader.load(GmInitializer.class)) {
            initializer.init();
        }
    }

    private static void loadProviders() {
        Securitys.loadGMSupports();
        Securitys.loadLangxProvider();
    }

    static {
        logger = LoggerFactory.getLogger(Securitys.class);
        Securitys.setup();
    }
}

