/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.pipeline;

import com.jn.langx.pipeline.Handler;
import com.jn.langx.pipeline.HandlerContext;
import com.jn.langx.pipeline.HeadHandlerContext;
import com.jn.langx.pipeline.Pipeline;
import com.jn.langx.pipeline.TailHandlerContext;
import com.jn.langx.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPipeline<T>
implements Pipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPipeline.class);
    private HeadHandlerContext head;
    private TailHandlerContext tail;
    private T target;
    private HandlerContext current = null;

    public DefaultPipeline() {
        this(new HeadHandlerContext(), new TailHandlerContext());
    }

    public DefaultPipeline(Handler handler) {
        this(handler, handler);
    }

    public DefaultPipeline(Handler headHandler, Handler tailHandler) {
        this(new HeadHandlerContext(headHandler), new TailHandlerContext(tailHandler));
    }

    private DefaultPipeline(HeadHandlerContext head, TailHandlerContext tail) {
        this.head = head;
        this.tail = tail;
        this.head.setNext(tail);
        this.tail.setPrev(head);
        head.setPipeline(this);
        tail.setPipeline(this);
    }

    @Override
    public void addFirst(Handler handler) {
        HandlerContext ctx = new HandlerContext(handler);
        ctx.setPipeline(this);
        HandlerContext first = this.head.getNext();
        first.setPrev(ctx);
        ctx.setNext(first);
        this.head.setNext(ctx);
        ctx.setPrev(this.head);
    }

    @Override
    public void addLast(Handler handler) {
        HandlerContext ctx = new HandlerContext(handler);
        ctx.setPipeline(this);
        HandlerContext last = this.tail.getPrev();
        last.setNext(ctx);
        ctx.setPrev(last);
        ctx.setNext(this.tail);
        this.tail.setPrev(ctx);
    }

    @Override
    public HeadHandlerContext getHead() {
        return this.head;
    }

    @Override
    public void reset() {
        this.clearHandlers(false);
    }

    @Override
    public void clear() {
        this.clearHandlers(true);
    }

    private void clearHandlers(boolean removeHeadAndTail) {
        this.setCurrentHandlerContext(null);
        HandlerContext ctx = this.getHead();
        if (ctx != null) {
            while (ctx.hasNext()) {
                HandlerContext next = ctx.getNext();
                if (removeHeadAndTail) {
                    ctx.clear();
                } else if (this.head == ctx || this.tail == ctx) {
                    ctx.clear(false);
                } else {
                    ctx.clear();
                }
                ctx = next;
            }
            if (removeHeadAndTail) {
                ctx.clear();
            } else if (this.head == ctx || this.tail == ctx) {
                ctx.clear(false);
            } else {
                ctx.clear();
            }
        }
        if (removeHeadAndTail) {
            this.head = null;
            this.tail = null;
        } else {
            this.setHeadHandler(this.head.getHandler());
            this.setTailHandler(this.tail.getHandler());
        }
        this.unbindTarget();
    }

    @Override
    public void inbound() throws Throwable {
        Preconditions.checkNotNull(this.target, "target is null");
        this.getHead().inbound();
    }

    @Override
    public void outbound() throws Throwable {
        Preconditions.checkNotNull(this.target, "target is null");
        Preconditions.checkNotNull(this.current, "current handler context is null");
        this.current.outbound();
    }

    @Override
    public void bindTarget(T target) {
        this.target = target;
    }

    @Override
    public void unbindTarget() {
        this.target = null;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    public void setHeadHandler(Handler headHandler) {
        HandlerContext next;
        Preconditions.checkTrue(this.head != null && !this.head.isSkiped() && !this.head.isInbounded() && !this.head.isOutbounded());
        HeadHandlerContext ctx = new HeadHandlerContext(headHandler);
        ctx.setPipeline(this);
        HandlerContext handlerContext = next = this.head == null ? null : this.head.getNext();
        if (next == null) {
            next = this.tail;
        }
        ctx.setNext(next);
        if (next != null) {
            next.setPrev(ctx);
        }
        this.head = ctx;
    }

    public void setTailHandler(Handler tailHandler) {
        HandlerContext prev;
        Preconditions.checkTrue(this.tail != null && !this.tail.isSkiped() && !this.tail.isInbounded() && !this.tail.isOutbounded());
        TailHandlerContext ctx = new TailHandlerContext(tailHandler);
        ctx.setPipeline(this);
        HandlerContext handlerContext = prev = this.tail == null ? null : this.tail.getPrev();
        if (prev == null) {
            prev = this.head;
        }
        ctx.setPrev(prev);
        if (prev != null) {
            prev.setNext(ctx);
        }
        this.tail = ctx;
    }

    @Override
    public boolean hadOutbound() {
        return false;
    }

    @Override
    public HandlerContext getCurrentHandlerContext() {
        return this.current;
    }

    @Override
    public void setCurrentHandlerContext(HandlerContext handlerContext) {
        this.current = handlerContext;
    }
}

