/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management.connector.remote.rmi;

import com.jn.langx.management.MBeanException;
import com.jn.langx.management.connector.remote.JMXRemoteConnectionFactory;
import com.jn.langx.management.connector.remote.RemoteConfiguration;
import com.jn.langx.management.connector.remote.rmi.RMIConfiguration;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.remote.JMXServiceURL;

public class RMIJMXConnectionFactory
extends JMXRemoteConnectionFactory {
    @Override
    protected JMXServiceURL buildJMXServiceUrl(RemoteConfiguration rmiConfig) {
        RMIConfiguration config = (RMIConfiguration)rmiConfig;
        String serviceName = config.getServerName();
        boolean startRmiRegistry = config.isStartRmiRegistry();
        String host = config.getHost();
        int port = config.getPort();
        StringBuilder url = new StringBuilder();
        if (serviceName == null) {
            serviceName = "jmxrmi";
        }
        if (startRmiRegistry) {
            int rmiRegistryPort = config.getRmiRegistryPort();
            url.append("service:jmx:rmi://").append(host).append(":");
            url.append(port);
            url.append("/jndi/rmi://").append(host).append(":");
            url.append(rmiRegistryPort);
            url.append("/").append(serviceName);
        } else {
            url.append("service:jmx:rmi:///jndi/rmi//").append(host).append(":").append(port).append("/").append(serviceName);
        }
        try {
            return new JMXServiceURL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    protected void setEnviroment(Map<String, Object> env, RemoteConfiguration config) {
        env.put("jmx.remote.credentials", new String[]{config.getUser(), config.getPassword()});
    }
}

