/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management.connector.remote;

import com.jn.langx.management.ConnectorConfiguration;
import com.jn.langx.management.JMXConnection;
import com.jn.langx.management.JMXConnectionFactory;
import com.jn.langx.management.connector.remote.JMXRemoteConnection;
import com.jn.langx.management.connector.remote.RemoteConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXRemoteConnectionFactory
implements JMXConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(JMXRemoteConnectionFactory.class);

    @Override
    public JMXConnection getConnection(ConnectorConfiguration config) {
        RemoteConfiguration conf = (RemoteConfiguration)config;
        JMXServiceURL serviceUrl = this.buildJMXServiceUrl(conf);
        HashMap<String, Object> env = new HashMap<String, Object>();
        this.setEnviroment(env, conf);
        JMXRemoteConnection conn = null;
        try {
            JMXConnector connector = JMXConnectorFactory.connect(serviceUrl, env);
            MBeanServerConnection connSub = connector.getMBeanServerConnection();
            conn = new JMXRemoteConnection(connSub);
            conn.setConnector(connector);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return conn;
    }

    protected abstract JMXServiceURL buildJMXServiceUrl(RemoteConfiguration var1);

    protected abstract void setEnviroment(Map<String, Object> var1, RemoteConfiguration var2);
}

