/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.management;

import com.jn.langx.management.MBeanService;
import com.jn.langx.registry.Registry;
import com.jn.langx.util.reflect.Reflects;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMBeanServiceProvider
implements Registry<Class, MBeanService> {
    private static final Logger logger = LoggerFactory.getLogger(BaseMBeanServiceProvider.class);
    private static final Map<Class<?>, MBeanService> registry = new ConcurrentHashMap();

    @Override
    public void register(MBeanService mBeanService) {
    }

    @Override
    public void register(Class key, MBeanService mBeanService) {
        registry.put(key, mBeanService);
    }

    @Override
    public MBeanService get(Class input) {
        return registry.get(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends MBeanService> S getService(Class<S> serviceClazz, ClassLoader classLoader) {
        if (serviceClazz == null) {
            return null;
        }
        MBeanService service = registry.get(serviceClazz);
        if (service != null && Reflects.isSubClassOrEquals(serviceClazz, service.getClass())) {
            return (S)service;
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            ServiceLoader<S> loader = ServiceLoader.load(serviceClazz);
            Iterator<S> iter = loader.iterator();
            while (iter.hasNext()) {
                MBeanService mBeanService;
                try {
                    MBeanService svc = (MBeanService)iter.next();
                    if (!svc.isServiceMatch()) continue;
                    registry.put(serviceClazz, svc);
                    mBeanService = svc;
                }
                catch (Throwable ex) {
                    logger.warn("Exception occured when get the service [" + serviceClazz + "]", ex);
                    continue;
                }
                return (S)mBeanService;
            }
            logger.warn("Can't find the service [" + serviceClazz + "]");
        }
        finally {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        return null;
    }
}

