/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.lifecycle;

import com.jn.langx.lifecycle.Destroyable;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Emptys;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Lifecycles {
    private static final Logger logger = LoggerFactory.getLogger(Lifecycles.class);

    public static void init(Object o) throws InitializationException {
        if (o instanceof Initializable) {
            Lifecycles.init((Initializable)o);
        }
    }

    public static void init(Initializable initializable) throws InitializationException {
        initializable.init();
    }

    public static void init(Collection c) throws InitializationException {
        if (Emptys.isEmpty(c)) {
            return;
        }
        for (Object o : c) {
            Lifecycles.init(o);
        }
    }

    public static void destroy(Object o) {
        if (o instanceof Destroyable) {
            Lifecycles.destroy((Destroyable)o);
        } else if (o instanceof Collection) {
            Lifecycles.destroy((Collection)o);
        }
    }

    public static void destroy(Destroyable d) {
        block3: {
            if (d != null) {
                try {
                    d.destroy();
                }
                catch (Throwable t) {
                    if (!logger.isDebugEnabled()) break block3;
                    String msg = "Unable to cleanly destroy instance [" + d + "] of type [" + d.getClass().getName() + "].";
                    logger.debug(msg, t);
                }
            }
        }
    }

    public static void destroy(Collection c) {
        if (Emptys.isEmpty(c)) {
            return;
        }
        for (Object o : c) {
            Lifecycles.destroy(o);
        }
    }
}

