/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class JavaBeanContext
implements Context {
    private Hashtable env = null;
    private ConcurrentHashMap<Name, Object> map = new ConcurrentHashMap(10);

    public JavaBeanContext() {
        this.env = new Hashtable();
    }

    public JavaBeanContext(Hashtable hashtable) {
        if (hashtable == null) {
            new JavaBeanContext();
        } else {
            this.env = new Hashtable(hashtable);
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new NamingException("name is null.");
        }
        return this.map.get(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.judgeName(name);
        if (this.map.containsKey(name)) {
            throw new NamingException("name is exist.");
        }
        this.map.put(name, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.judgeName(name);
        if (!this.map.containsKey(name)) {
            this.bind(name, obj);
        } else {
            this.map.put(name, obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.judgeName(name);
        if (this.map.containsKey(name)) {
            this.map.remove(name);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.judgeName(oldName);
        Object value = this.map.remove(oldName);
        this.bind(newName, value);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return new NamingEnumeration<NameClassPair>(){
            private Enumeration<Name> enumer;
            {
                this.enumer = JavaBeanContext.this.map.keys();
            }

            @Override
            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            @Override
            public NameClassPair nextElement() {
                Name name = this.enumer.nextElement();
                Object value = JavaBeanContext.this.map.get(name);
                return new NameClassPair(name.toString(), value.getClass().getName());
            }

            @Override
            public NameClassPair next() throws NamingException {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() throws NamingException {
                return this.hasMoreElements();
            }

            @Override
            public void close() throws NamingException {
            }
        };
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return new NamingEnumeration<Binding>(){
            private Enumeration<Name> enumer;
            {
                this.enumer = JavaBeanContext.this.map.keys();
            }

            @Override
            public boolean hasMoreElements() {
                return this.enumer.hasMoreElements();
            }

            @Override
            public Binding nextElement() {
                Name name = this.enumer.nextElement();
                return new Binding(name.toString(), JavaBeanContext.this.map.get(name));
            }

            @Override
            public Binding next() throws NamingException {
                return this.nextElement();
            }

            @Override
            public boolean hasMore() throws NamingException {
                return this.hasMoreElements();
            }

            @Override
            public void close() throws NamingException {
            }
        };
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return null;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return null;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.env.put(propName, propVal);
        return propVal;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return new Hashtable(this.env);
    }

    @Override
    public void close() throws NamingException {
        this.map.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }

    public void judgeName(Object name) throws NamingException {
        if (name == null) {
            throw new NamingException("name is null.");
        }
    }
}

