/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.io.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;

public class DelimiterBasedReadableByteChannel
implements ReadableByteChannel,
Iterable<byte[]> {
    private ByteBuffer delimiter;
    private ReadableByteChannel channel;
    private ByteBuffer buf;
    private boolean eof = false;

    public DelimiterBasedReadableByteChannel(ReadableByteChannel channel, String delimiter) {
        Preconditions.checkNotNull(channel, "channel is null");
        this.channel = channel;
        this.setDelimiter(delimiter);
    }

    public int read(ByteBuffer dst, String delimiter) throws IOException {
        this.setDelimiter(delimiter);
        return this.read(dst);
    }

    public void setDelimiter(String delimiter) {
        Preconditions.checkTrue(Strings.isNotEmpty(delimiter), "delimiter is null or empty");
        this.delimiter = ByteBuffer.wrap(delimiter.getBytes(Charsets.UTF_8));
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.channel.read(dst);
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){

            @Override
            public boolean hasNext() {
                try {
                    return DelimiterBasedReadableByteChannel.this.hasNextSegment();
                }
                catch (IOException ex) {
                    return false;
                }
            }

            @Override
            public byte[] next() {
                try {
                    ByteBuffer byteBuffer = DelimiterBasedReadableByteChannel.this.nextSegment();
                    byte[] bytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(bytes);
                    return bytes;
                }
                catch (IOException ex) {
                    return new byte[0];
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int fill() throws IOException {
        if (this.buf == null) {
            this.buf = ByteBuffer.allocate(8192);
            this.buf.mark();
        } else {
            this.buf.reset();
            if (!this.buf.hasRemaining()) {
                this.buf.clear();
                this.buf.mark();
            } else if (this.buf.remaining() <= this.buf.capacity() / 3) {
                ByteBuffer moving = this.buf.slice();
                moving.limit(this.buf.remaining());
                this.buf.clear();
                this.buf.mark();
                this.buf.put(moving);
            } else {
                ByteBuffer buf2 = ByteBuffer.allocate(this.buf.capacity() * 2);
                ByteBuffer moving = this.buf.slice();
                moving.limit(this.buf.remaining());
                buf2.mark();
                buf2.put(moving);
                this.buf = buf2;
            }
        }
        int length = this.channel.read(this.buf);
        if (length == -1) {
            this.eof = true;
        }
        this.buf.limit(this.buf.position());
        this.buf.reset();
        return length;
    }

    public boolean hasNextSegment() throws IOException {
        if (!(this.buf != null && this.buf.hasRemaining() && this.buf.remaining() >= this.delimiter.limit() || this.eof)) {
            this.fill();
        }
        return this.buf != null && this.buf.hasRemaining();
    }

    public ByteBuffer nextSegment() throws IOException {
        if (!(this.buf != null && this.buf.hasRemaining() && this.buf.remaining() >= this.delimiter.limit() || this.eof)) {
            this.fill();
        }
        if (this.eof) {
            return this.buf;
        }
        if (!this.buf.hasRemaining()) {
            return this.buf;
        }
        this.buf.mark();
        this.delimiter.clear();
        byte firstByteOfDelimiter = this.delimiter.get();
        block0: while (this.buf.hasRemaining() && this.buf.remaining() >= this.delimiter.limit()) {
            if (this.buf.get() != firstByteOfDelimiter) continue;
            while (this.delimiter.hasRemaining() && this.buf.remaining() >= this.delimiter.remaining()) {
                if (this.delimiter.get() == this.buf.get()) continue;
                this.delimiter.clear();
                firstByteOfDelimiter = this.delimiter.get();
                continue block0;
            }
            this.delimiter.clear();
            int current = this.buf.position();
            this.buf.reset();
            ByteBuffer ret = this.buf.slice();
            ret.limit(current - this.delimiter.limit() - this.buf.position());
            int bufferLimit = this.buf.limit();
            this.buf.clear();
            this.buf.limit(bufferLimit);
            this.buf.position(current);
            this.buf.mark();
            return ret;
        }
        return this.nextSegment();
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

