/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.stream;

import com.jn.langx.util.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 8192;
    private byte[] realBuf;
    private ByteBuffer buf;

    private InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    public BufferedInputStream(InputStream in) {
        this(in, defaultBufferSize);
    }

    public BufferedInputStream(InputStream in, int size) {
        super(in);
        Preconditions.checkTrue(size > 0, "Buffer size <= 0");
        this.realBuf = new byte[size];
    }

    private void fill() throws IOException {
        this.fill(this.realBuf.length);
    }

    private void fill(int maxSize) throws IOException {
        int length;
        Preconditions.checkTrue(maxSize > 0);
        if (this.buf != null) {
            this.buf.clear();
        }
        if (maxSize > this.realBuf.length) {
            this.realBuf = new byte[maxSize];
        }
        if ((length = this.in.read(this.realBuf, 0, maxSize)) != -1) {
            this.buf = ByteBuffer.wrap(this.realBuf, 0, length);
        } else if (this.buf != null) {
            this.buf.clear();
            this.buf.limit(0);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        return this.readByte();
    }

    private synchronized byte readByte() throws IOException {
        if (this.buf == null) {
            if (this.in.available() > 0) {
                this.fill();
            }
            if (this.buf == null) {
                return -1;
            }
        }
        if (!this.buf.hasRemaining()) {
            this.fill();
            if (!this.buf.hasRemaining()) {
                return -1;
            }
        }
        return this.buf.get();
    }

    private int read1(byte[] bytes, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            byte b = this.readByte();
            if (b != -1) {
                bytes[off] = b;
                ++off;
                continue;
            }
            if (i != 0) break;
            return -1;
        }
        return i;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        return this.read1(b, off, len);
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        throw new IOException("Unsupported skip");
    }

    @Override
    public synchronized int available() throws IOException {
        return this.getInIfOpen().available() + (this.buf.limit() - this.buf.position());
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buf.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public ByteBuffer readAsByteBuffer() throws IOException {
        return this.readAsByteBuffer(this.realBuf.length);
    }

    public ByteBuffer readAsByteBuffer(int maxSize) throws IOException {
        if (this.buf == null || !this.buf.hasRemaining()) {
            this.fill(maxSize);
            return this.buf;
        }
        return this.buf;
    }
}

