/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.io.resource.AbstractLocatableResource;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.net.URLs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class UrlResource
extends AbstractLocatableResource<URL> {
    private URL url;

    public UrlResource(String url) {
        this(URLs.newURL(url));
    }

    public UrlResource(URI uri) {
        this(URLs.toURL(uri));
    }

    public UrlResource(URL url) {
        Preconditions.checkNotNull(url);
        this.url = url;
        String protocol = url.getProtocol();
        String prefix = URLs.getUrlPrefix(protocol);
        String path = url.toString();
        if (path.startsWith(prefix)) {
            path = path.substring(prefix.length());
        }
        this.setLocation(prefix, path);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return URLs.getInputStream(this.url);
    }

    @Override
    public boolean exists() {
        return URLs.exists(this.url);
    }

    @Override
    public String getAbsolutePath() {
        File file;
        if (URLs.isFileURL(this.url) && (file = URLs.getFile(this.url)) != null) {
            return file.getAbsolutePath();
        }
        return this.url.getPath();
    }

    @Override
    public URL getRealResource() {
        return this.url;
    }

    @Override
    public long contentLength() {
        return URLs.getContentLength(this.url);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UrlResource)) {
            return false;
        }
        UrlResource o2 = (UrlResource)obj;
        return this.url.equals(o2.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }
}

