/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.resource.ByteArrayResource;
import com.jn.langx.io.resource.ClassPathResource;
import com.jn.langx.io.resource.DefaultResourceLoader;
import com.jn.langx.io.resource.FileResource;
import com.jn.langx.io.resource.InputStreamResource;
import com.jn.langx.io.resource.Location;
import com.jn.langx.io.resource.Locations;
import com.jn.langx.io.resource.Resource;
import com.jn.langx.io.resource.UrlResource;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.io.Channels;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.net.URLs;
import com.jn.langx.util.struct.Holder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;

public class Resources {
    public static <V extends Resource> V loadResource(@NonNull Location location) {
        return Locations.newResource(location.toString());
    }

    public static <V extends Resource> V loadResource(@NonNull String location) {
        return Resources.loadResource(location, null);
    }

    public static <V extends Resource> V loadResource(@NonNull String location, @Nullable ClassLoader classLoader) {
        return new DefaultResourceLoader(classLoader).loadResource(location);
    }

    public static FileResource loadFileResource(@NonNull File file) {
        return Resources.loadFileResource(file.getAbsolutePath(), null);
    }

    public static FileResource loadFileResource(@NonNull String location) {
        return Resources.loadFileResource(location, null);
    }

    public static FileResource loadFileResource(@NonNull String location, @Nullable ClassLoader classLoader) {
        Preconditions.checkNotNull(location);
        if (!Strings.startsWith(location, "file:")) {
            location = "file:" + location;
        }
        return (FileResource)new DefaultResourceLoader(classLoader).loadResource(location);
    }

    public static ClassPathResource loadClassPathResource(@NonNull String location) {
        return Resources.loadClassPathResource(location, (ClassLoader)null);
    }

    public static ClassPathResource loadClassPathResource(@NonNull String location, @Nullable ClassLoader classLoader) {
        Preconditions.checkNotNull(location);
        if (!Strings.startsWith(location, "classpath:")) {
            location = "classpath:" + location;
        }
        return (ClassPathResource)new DefaultResourceLoader(classLoader).loadResource(location);
    }

    public static ClassPathResource loadClassPathResource(@NonNull String location, @Nullable Class clazz) {
        Preconditions.checkNotNull(location);
        if (!Strings.startsWith(location, "classpath:")) {
            location = "classpath:" + location;
        }
        return new ClassPathResource(location, clazz);
    }

    public static UrlResource loadUrlResource(@NonNull String location) {
        return Resources.loadUrlResource(location, null);
    }

    public static UrlResource loadUrlResource(@NonNull String location, @Nullable ClassLoader classLoader) {
        Preconditions.checkNotNull(URLs.newURL(location), StringTemplates.formatWithPlaceholder("location : {} not a URL", location));
        return (UrlResource)new DefaultResourceLoader(classLoader).loadResource(location);
    }

    public static UrlResource loadUrlResource(@NonNull URL url) {
        return new UrlResource(url);
    }

    public static ByteArrayResource asByteArrayResource(@NonNull byte[] byteArray) {
        return new ByteArrayResource(byteArray);
    }

    public static ByteArrayResource asByteArrayResource(@NonNull byte[] byteArray, @Nullable String description) {
        return new ByteArrayResource(byteArray, description);
    }

    public static InputStreamResource asInputStreamResource(@NonNull InputStream inputStream) {
        return new InputStreamResource(inputStream);
    }

    public static InputStreamResource asInputStreamResource(@NonNull InputStream inputStream, @Nullable String description) {
        return new InputStreamResource(inputStream, description);
    }

    public static boolean exists(String resource) {
        Object res = Resources.loadResource(resource);
        if (res == null) {
            return false;
        }
        return res.exists();
    }

    public static InputStream getInputStream(String resource) throws IOException {
        Object res = Resources.loadResource(resource);
        if (res == null) {
            throw new IOException(StringTemplates.formatWithPlaceholder("Can't find the resource: {}", resource));
        }
        return res.getInputStream();
    }

    public static void readUsingDelimiter(Resource resource, @NonNull String delimiter, @NonNull Consumer<byte[]> consumer) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            Channels.readUsingDelimiter(inputStream, delimiter, consumer);
        }
        catch (IOException ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
        finally {
            IOs.close(inputStream);
        }
    }

    public static void readUsingDelimiter(Resource resource, @NonNull String delimiter, @NonNull Charset charset, final @NonNull Consumer<String> consumer) {
        Resources.readUsingDelimiter(resource, delimiter, charset, new Consumer2<Integer, String>(){

            @Override
            public void accept(Integer index, String value) {
                consumer.accept(value);
            }
        });
    }

    public static void readUsingDelimiter(Resource resource, @NonNull String delimiter, @NonNull Charset charset, @NonNull Consumer2<Integer, String> consumer) {
        Resources.readUsingDelimiter(resource, delimiter, charset, null, consumer, null);
    }

    public static void readUsingDelimiter(Resource resource, @NonNull String delimiter, @NonNull Charset charset, @Nullable Predicate2<Integer, String> consumePredicate, @NonNull Consumer2<Integer, String> consumer, @Nullable Predicate2<Integer, String> breakPredicate) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            Channels.readUsingDelimiter(inputStream, delimiter, charset, consumePredicate, consumer, breakPredicate);
        }
        catch (IOException ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
        finally {
            IOs.close(inputStream);
        }
    }

    public static void readUsingDelimiter(@NonNull String location, @NonNull String delimiter, @NonNull Charset charset, @NonNull Consumer<String> consumer) {
        Preconditions.checkNotNull(location);
        Object resource = Resources.loadResource(location);
        if (resource.exists() && resource.isReadable()) {
            Resources.readUsingDelimiter(resource, delimiter, charset, consumer);
        }
    }

    public static void readUsingDelimiter(@NonNull String location, @NonNull String delimiter, @NonNull Charset charset, @NonNull Consumer2<Integer, String> consumer) {
        Preconditions.checkNotNull(location);
        Object resource = Resources.loadResource(location);
        if (resource.exists() && resource.isReadable()) {
            Resources.readUsingDelimiter(resource, delimiter, charset, consumer);
        }
    }

    public static void readUsingDelimiter(@NonNull String location, @NonNull String delimiter, @NonNull Charset charset, @Nullable Predicate2<Integer, String> consumePredicate, @NonNull Consumer2<Integer, String> consumer, @Nullable Predicate2<Integer, String> breakPredicate) {
        Preconditions.checkNotNull(location);
        Object resource = Resources.loadResource(location);
        if (resource.exists() && resource.isReadable()) {
            Resources.readUsingDelimiter(resource, delimiter, charset, consumePredicate, consumer, breakPredicate);
        }
    }

    public static void readUsingDelimiter(@NonNull URL url, @NonNull String delimiter, @NonNull Charset charset, @NonNull Consumer<String> consumer) {
        Resources.readUsingDelimiter((Resource)Resources.loadUrlResource(url), delimiter, charset, consumer);
    }

    public static void readUsingDelimiter(@NonNull byte[] byteArray, @NonNull String delimiter, @NonNull Charset charset, @NonNull Consumer<String> consumer) {
        ByteArrayResource resource = Resources.asByteArrayResource(byteArray);
        if (resource.exists() && resource.isReadable()) {
            Resources.readUsingDelimiter((Resource)resource, delimiter, charset, consumer);
        }
    }

    public static void readLines(@NonNull String location, @NonNull Charset charset, @NonNull Consumer<String> consumer) {
        Resources.readUsingDelimiter(location, "\n", charset, consumer);
    }

    public static void readLines(@NonNull String location, @NonNull Charset charset, @NonNull Consumer2<Integer, String> consumer) {
        Resources.readUsingDelimiter(location, "\n", charset, consumer);
    }

    public static void readLines(@NonNull String location, @NonNull Charset charset, @Nullable Predicate2<Integer, String> consumePredicate, @NonNull Consumer2<Integer, String> consumer, @Nullable Predicate2<Integer, String> breakPredicate) {
        Resources.readUsingDelimiter(location, "\n", charset, consumePredicate, consumer, breakPredicate);
    }

    public static String readFirstLine(@NonNull String location, @NonNull Charset charset) {
        final Holder firstLine = new Holder();
        Resources.readLines(location, charset, new Predicate2<Integer, String>(){

            @Override
            public boolean test(Integer index, String line) {
                return index == 0;
            }
        }, new Consumer2<Integer, String>(){

            @Override
            public void accept(Integer index, String line) {
                firstLine.set(line);
            }
        }, new Predicate2<Integer, String>(){

            @Override
            public boolean test(Integer index, String value) {
                return index != 0;
            }
        });
        return (String)firstLine.get();
    }
}

