/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.io.resource;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.io.resource.AbstractResource;
import com.jn.langx.io.resource.Locatable;
import com.jn.langx.io.resource.Location;
import com.jn.langx.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamResource
extends AbstractResource<InputStream>
implements Locatable {
    private final InputStream inputStream;
    private final String path;
    private boolean read = false;

    @Override
    public InputStream getRealResource() {
        return this.inputStream;
    }

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, "resource loaded through InputStream");
    }

    public String getDescription() {
        return this.path;
    }

    @Override
    public String getPrefix() {
        return "inputstream:";
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Location getLocation() {
        return new Location(this.getPrefix(), this.getPath());
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    public InputStreamResource(InputStream inputStream, @Nullable String path) {
        Preconditions.checkNotNull(inputStream, "InputStream must not be null");
        this.inputStream = inputStream;
        this.path = path != null ? path : "";
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long contentLength() {
        return -1L;
    }

    @Override
    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.read) {
            throw new IllegalStateException("InputStream has already been read - do not use InputStreamResource if a stream needs to be read multiple times");
        }
        this.read = true;
        return this.inputStream;
    }

    public String toString() {
        return "InputStream resource [" + this.path + "]";
    }

    public boolean equals(Object other) {
        return this == other || other instanceof InputStreamResource && ((InputStreamResource)other).inputStream.equals(this.inputStream);
    }

    public int hashCode() {
        return this.inputStream.hashCode();
    }
}

