/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.invocation.aop;

import com.jn.langx.invocation.GenericMethodInvocation;
import com.jn.langx.invocation.aop.MethodInterceptor;
import com.jn.langx.util.Emptys;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AopMethodInvocation
extends GenericMethodInvocation {
    private List<MethodInterceptor> interceptors = new ArrayList<MethodInterceptor>();
    private int currentInterceptorIndex = -1;

    public AopMethodInvocation(Object proxy, Object target, Method method, Object[] arguments) {
        super(proxy, target, method, arguments);
    }

    public void setInterceptors(List<MethodInterceptor> interceptors) {
        if (Emptys.isNotEmpty(interceptors)) {
            this.interceptors.addAll(interceptors);
        }
    }

    @Override
    public Object proceed() throws Throwable {
        if (this.currentInterceptorIndex == this.interceptors.size() - 1) {
            return this.doProceed();
        }
        ++this.currentInterceptorIndex;
        MethodInterceptor interceptor = this.interceptors.get(this.currentInterceptorIndex);
        return interceptor.intercept(this);
    }

    protected Object doProceed() {
        try {
            Method method = this.getJoinPoint();
            method.setAccessible(true);
            return method.invoke(this.getThis(), this.getArguments());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

